% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_process.R
\name{genETARCH}
\alias{genETARCH}
\title{Generate an Exponential TAR-ARCH Process}
\usage{
genETARCH(n, alpha1, alpha2, beta)
}
\arguments{
\item{n}{An integer value; the length of the process to simulate.}

\item{alpha1}{A numeric value; parameter of the process such that \eqn{|alpha1|<1}.}

\item{alpha2}{A numeric value; parameter of the process driving the behaviour of the process
for small values of \code{x}. \eqn{|alpha1+alpha2|} may be bigger than 1.}

\item{beta}{A positive numeric value; parameter of the process driving the ARCH effect.}
}
\value{
A numeric vector of length \code{n+1}, containing the simulated values
of the ETAR-ARCH process.
}
\description{
Simulates an Exponential Threshold Autoregressive (ETAR)-ARCH process.
}
\details{
The ETAR-ARCH process is defined by the equation
\deqn{X_{t+1} = \left(\alpha_1 + \alpha_2 \exp(-X_t^2)\right)X_t + \sqrt{1 + \beta X_t^2} Z_t},
where \eqn{Z_t} is an i.i.d. error sequence.
}
\examples{
etarch = genETARCH(100,0.3,0.8,0.5) 
plot(etarch, type="l")

}
\references{
Bertail, P. and Dudek, A. (2025). \emph{Bootstrap for
Dependent Data, with an R package} (by Bernard Desgraupes and Karolina Marek)  - submitted.
}
\seealso{
\code{\link{genMM1}}, \code{\link{zi_inar_process}}.
}
\keyword{"Conditional}
\keyword{"Thresholds}
\keyword{heteroscedasticity"}
\keyword{models"}
