% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mark_boot.R
\name{mark_boot}
\alias{mark_boot}
\title{Bootstraping Markov chain}
\usage{
mark_boot(X, func, B, ...)
}
\arguments{
\item{X}{A numeric vector representing a Markov chain.}

\item{func}{The function to apply to each sample.}

\item{B}{A positive integer; the number of bootstrap samples.}

\item{...}{Optional additional arguments for the \code{func} function.}
}
\value{
Returns an object of class \code{boodd}.
}
\description{
The function fo bootstrap the Markov chain using estimator of the
transition kernel
}
\details{
The method is based on estimating the transition
kernel of the chain,
which is used to generate the bootstrap time series.
The transition density is estimated using some Gaussian kernel.
}
\examples{
set.seed(12345)
phi=0.6
n=200
X <- arima.sim(list(order=c(1,0,0),ar=phi),n=n)
 boo1=mark_boot(X,mean,199)
 boot_dist(boo1)
 # Compute confidence intervals
 confint(boo1,method="all")
}
\references{
Bertail, P. and Dudek, A. (2025). \emph{Bootstrap for
Dependent Data, with an R package} (by Bernard Desgraupes and Karolina Marek) - submitted..

Prakasa Rao, B. L. S. and Kulperger, R. J. (1989). Bootstrapping a
finite state Markov chain. \emph{Sankhya - Series A}, \bold{51}, 178-191.

Rajarshi, M.B. (1990). Bootstrap in Markov-Sequences Based on Estimates of
Transition Density. \emph{Annals of the Institute of Statistical Mathematics},
\bold{42}, 253-268.
}
\seealso{
\code{\link{blockboot}},
\code{\link{regenboot}},
\code{\link{findBestEpsilon}}.
}
\keyword{"Markov}
\keyword{"Transition}
\keyword{bootstrap"}
\keyword{chains"}
\keyword{density}
\keyword{estimators"}
