% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/facto_mfa.R
\name{facto_mfa}
\alias{facto_mfa}
\title{Perform MFA with FactoMineR's style}
\usage{
facto_mfa(X, groups, ncp = 2)
}
\arguments{
\item{X}{a data frame with n rows (individuals) and p columns (numeric variables)}

\item{groups}{a vector indicating the group of each variable}

\item{ncp}{an integer, the number of components to keep (value set by default)}
}
\value{
A list containing results of FactoMineR's multiple factor analysis (MFA).
}
\description{
Return MFA results with FactoMineR's style
}
\examples{
library(booklet)

res <- facto_mfa(X = iris[, -c(5)], groups = c(2, 2), ncp = 2)
}
