% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GOF_model.R
\name{GOF_model}
\alias{GOF_model}
\title{Convenience function for creating a GOF-test for statistical models}
\usage{
GOF_model(
  model,
  data,
  nmb_boot_samples,
  simulator_type,
  y_name,
  Rn1_statistic,
  gof_model_resample_class = GOF_model_resample,
  gof_model_test_class = GOF_model_test
)
}
\arguments{
\item{model}{of class 'lm' or 'glm'. Caution with MASS::glm.nb, see
vignette 'New-Models' for more details.}

\item{data}{see \link{GOF_model_test}}

\item{nmb_boot_samples}{see \link{GOF_model_test}}

\item{simulator_type}{either "parameteric" or "semi_parameteric_rademacher"}

\item{y_name}{see \link{GOF_model_test}}

\item{Rn1_statistic}{see \link{GOF_model_test}}

\item{gof_model_resample_class}{no need to change this parameter. Here the
class used for resampling the model (\link{GOF_model_resample})
is injected. This parameter simply makes it easier to test the
convenience function properly.}

\item{gof_model_test_class}{no need to change this parameter. Here the
class used for performing the GOF test (\link{GOF_model_test})
is injected. This parameter simply makes it easier to test the
convenience function properly.}
}
\value{
instance of \link{GOF_model_test}
}
\description{
Simplifies the creation of an instance of
  \link{GOF_model_test}, the actual work horse for performing a
  goodness-of-fit-test.
}
\examples{
set.seed(1)
N <- 100
X1 <- rnorm(N)
X2 <- rnorm(N)
d <- data.frame(
  y = rpois(n = N, lambda = exp(4 + X1 * 2 + X2 * 6)),
  x1 = X1,
  x2 = X2)
fit <- glm(y ~ x1, data = d, family = poisson())
mt <- GOF_model(
  model = fit,
  data = d,
  nmb_boot_samples = 100,
  simulator_type = "parametric",
  y_name = "y",
  Rn1_statistic = Rn1_KS$new())
mt$get_pvalue()
fit <- glm(y ~ x1 + x2, data = d, family = poisson())
mt <- GOF_model(
  model = fit,
  data = d,
  nmb_boot_samples = 100,
  simulator_type = "parametric",
  y_name = "y",
  Rn1_statistic = Rn1_KS$new())
mt$get_pvalue()
}
