% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtable.R
\name{dtable}
\alias{dtable}
\title{dtable}
\usage{
dtable(x, bset, bsep = ".", asep = ";", missing = "x", noc = "0")
}
\arguments{
\item{x}{data frame containing raw focal observations' data, referring to
dyadic social interactions. This data frame should contain one focal
observation per row and 3 columns. The first column should refer to focal's
subject identification code; the second, to the recorded dyadic social
interactions; and the third, to observer's identification code. See
ex_field_data for further details on the structure of this data frame.}

\item{bset}{A vector specifying the codes of the recorded social
interactions.}

\item{bsep}{The separation character used in the second column of x to
separate subject's id code from social interactions code. Default is ".".}

\item{asep}{The separation character used in the second column of x to
separate different social interactions recorded within the same focal
sample. Default is ";".}

\item{missing}{A character, used in the second column of x, to identify focal
observations where the focal subject was unavailable for observation.
Default is "x".}

\item{noc}{A character, used in the second column of x, to identify focal
observations where no social interactions were recorded. Default is "0".}
}
\value{
dtable returns a data frame with 7 columns: "id1" identifies the
  focal subject's; "sender_id1" identifies whether the focal's subject (id1)
  was the initiator of the dyadic social interaction (coded 1), or the target
  of the social interaction (coded 0; in this case the initiator is the
  subject referred in the column "id2"); "behavior" identifies the social
  interaction observed; if no social interactions were recorded in a focal
  sample, "no_occurrence" and "missing" columns specify whether the focal
  subject was observed but did not interact, or was unavailable for
  observation, respectively; "observer" columns identifies the observer.
}
\description{
dtable takes a data frame containing raw focal observations' data and
transforms it into another data frame more suitable for further data
analysis.
}
\examples{
## convert raw focal observations' data in ex_field_data
## see ?ex_field_data for further details
## bsep, asep, missing and noc arguments take default values (".", ";", "x", "0" respectively)
b <- c("+","-")
data <- dtable(ex_field_data, bset = b)
head(data)
}
