% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxr_misc.R
\name{box_ls}
\alias{box_ls}
\title{List files in a Box directory}
\usage{
box_ls(dir_id = box_getwd(), limit = 100, max = Inf, fields = NULL)
}
\arguments{
\item{dir_id}{\code{numeric} or \code{character}, folder ID at Box.}

\item{limit}{\code{integer}, maximum number of entries to retrieve per query-page.}

\item{max}{\code{integer}, maximum number of entries to retrieve in total.}

\item{fields}{\code{character}, fields to return; the default
value, \code{NULL}, will return all possible fields from API: \code{modified_at},
\code{content_modified_at}, \code{name}, \code{id}, \code{type}, \code{sha1} ,\code{size},
\code{owned_by}, \code{path_collection}, \code{description}, \code{file_version}.}
}
\value{
Object with S3 class \code{\link[=boxr_S3_classes]{boxr_object_list}}.
}
\description{
Non-recursive
}
\seealso{
\code{\link[=box_fetch]{box_fetch()}} and \code{\link[=box_push]{box_push()}} for synchronizing the contents of
local and remote directories.
}
