% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.PosteriorBVARs}
\alias{summary.PosteriorBVARs}
\title{Provides posterior estimation summary for Bayesian  
Vector Autoregressions for dynamic panel data}
\usage{
\method{summary}{PosteriorBVARs}(object, ...)
}
\arguments{
\item{object}{an object of class \code{PosteriorBVARs} obtained using the
\code{estimate()} function applied to  
Vector Autoregressions containing draws from the  posterior distribution of 
the parameters.}

\item{...}{additional arguments affecting the summary produced.}
}
\value{
A list reporting the posterior mean, standard deviations, as well as 5 and 95 
percentiles of the country-specific parameters.
}
\description{
Provides posterior mean, standard deviations, as well as 5 and 95 
percentiles of the parameters for all \code{C} countries.
}
\examples{
# specify the model
specification = specify_bvarPANEL$new(
      ilo_dynamic_panel[1:5], 
      exogenous = ilo_exogenous_variables[1:5])
burn_in       = estimate(specification, 5)             # run the burn-in
posterior     = estimate(burn_in, 5)                   # estimate the model
summary(posterior)

}
\seealso{
\code{\link{estimate.BVARs}}, \code{\link{specify_bvars}}
}
\author{
Tomasz Woźniak \email{wozniak.tom@pm.me}
}
