% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stage_constructors.R
\name{single_elim_stage}
\alias{single_elim_stage}
\alias{double_elim_stage}
\alias{round_robin_stage}
\alias{swiss_stage}
\alias{group_stage_knockout_stage}
\alias{two_leg_stage}
\title{Create a stage specification}
\usage{
single_elim_stage(
  seed = TRUE,
  third_place = FALSE,
  best_of = NULL,
  reseed = FALSE
)

double_elim_stage(
  seed = TRUE,
  grand_final_reset = TRUE,
  best_of = NULL,
  reseed = FALSE
)

round_robin_stage(
  home_away = FALSE,
  n_rounds = NULL,
  best_of = NULL,
  tiebreakers = NULL,
  groups = NULL
)

swiss_stage(
  rounds = NULL,
  seed = TRUE,
  allow_ties = TRUE,
  bye_points = 1,
  best_of = NULL,
  tiebreakers = NULL
)

group_stage_knockout_stage(
  groups = 2,
  advance_per_group = 2,
  seed = TRUE,
  group_home_away = FALSE,
  group_best_of = NULL,
  group_tiebreakers = NULL,
  knockout_type = "single_elim",
  knockout_seed = TRUE,
  third_place = FALSE,
  grand_final_reset = TRUE,
  knockout_best_of = NULL
)

two_leg_stage(
  seed = TRUE,
  third_place = FALSE,
  away_goals = TRUE,
  reseed = FALSE
)
}
\arguments{
\item{seed}{Logical or character seed method.}

\item{third_place}{Logical; include third-place match.}

\item{best_of}{Optional best-of value (must be odd).}

\item{reseed}{Logical; reseed between rounds for supported formats.}

\item{grand_final_reset}{Logical; allow grand-final reset.}

\item{home_away}{Logical; whether repeated pairings alternate home/away.}

\item{n_rounds}{Number of round-robin cycles.}

\item{tiebreakers}{Ordered tiebreakers.}

\item{groups}{Number of groups.}

\item{rounds}{Number of Swiss rounds.}

\item{allow_ties}{Logical; whether ties are allowed.}

\item{bye_points}{Points awarded for a bye.}

\item{advance_per_group}{Number of qualifiers per group.}

\item{group_home_away}{Logical; home/away behavior in groups.}

\item{group_best_of}{Optional best-of in groups.}

\item{group_tiebreakers}{Ordered group-stage tiebreakers.}

\item{knockout_type}{Knockout format: \code{"single_elim"} or \code{"double_elim"}.}

\item{knockout_seed}{Logical or character seed method for knockout.}

\item{knockout_best_of}{Optional knockout best-of value.}

\item{away_goals}{Logical; enable away-goals tiebreaker.}
}
\value{
A \code{stage_spec} object.
}
\description{
Stage specifications describe how to materialize a stage bracket from a
participant set inside a \code{tournament_spec} graph.
}
