% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootBraidModel.R
\name{calcBraidConfInt}
\alias{calcBraidConfInt}
\title{Generic BRAID confidence intervals}
\usage{
calcBraidConfInt(bfit, parfunc, civals = NULL)
}
\arguments{
\item{bfit}{A BRAID fit object of class \code{braidrm} which contains a full set
of bootstrapped response surface coefficients}

\item{parfunc}{A function that takes a full-length BRAID parameter vector as
an input and gives a single numeric value or numeric vector as an output. If
the function produces a vector, it must produce the same length vector for
all inputs}

\item{civals}{If given, the lower and upper quantile values at which the
confidence intervals are set.  Defaults to the \code{ciLevs} parameter of the
bootstrapped BRAID fit}
}
\value{
An n-by-3 array, where n is the length of the output produced by
\code{parfunc}.  The first column is the lower bound of the confidence interval;
the second column is the derived value for the best fit coefficients; and the
third column is the upper bound of the confidence intervals. Note that is
possible for the lower bound of the confidence interval to lie above the
central value, or for the upper bound to lie below it; though this is only
likely to occur in the case of a poorly determined fit.
}
\description{
Generates confidence intervals on derived BRAID response surface values
}
\details{
In come cases, it is desirable to estimate a confidence interval on a value
derived from or dependent on a BRAID surface model that is not a parameter of
the model itself. For example, one might want a confidence interval on a
given index of achievable efficacy value, or the predicted effect at a
certain set of dose pairs. This function replicates confidence interval
calculations on any such derive values
}
\examples{
bfit <- braidrm(measure ~ concA + concB, synergisticExample, getCIs=TRUE)

calcBraidConfInt(bfit, function(p) evalBraidModel(10, 10, p))
calcBraidConfInt(bfit, function(p) estimateIAE(p, c(0.5, 0.9), c(10, 10)))
}
