% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sass.R
\name{brand_sass_fonts}
\alias{brand_sass_fonts}
\title{Generate Sass variables and CSS rules for brand fonts}
\usage{
brand_sass_fonts(brand)
}
\arguments{
\item{brand}{A list or string of YAML representing the brand, or a path to a
brand.yml file.}
}
\value{
A list with two components:
\itemize{
\item \code{defaults}: Sass variables for font definitions
\item \code{rules}: CSS rules for applying fonts via classes
}
}
\description{
Creates Sass variables and CSS rules for fonts defined in the brand object.
Supports Google fonts, Bunny fonts, and file-based fonts.
}
\examples{
\dontshow{if (requireNamespace("sass", quietly = TRUE)) withAutoprint(\{ # examplesIf}
brand <- list(
  typography = list(
    fonts = list(
      list(
        family = "Roboto",
        source = "google",
        weight = c(400, 700),
        style = "normal"
      )
    )
  )
)

brand_sass_fonts(brand)
\dontshow{\}) # examplesIf}
}
\seealso{
Other brand.yml Sass helpers: 
\code{\link{brand_sass_color}()},
\code{\link{brand_sass_color_palette}()},
\code{\link{brand_sass_defaults_bootstrap}()},
\code{\link{brand_sass_typography}()}
}
\concept{brand.yml Sass helpers}
