#'  White Wine Quality Data
#'
#' White wine quality data related to variants of the Portuguese "Vinho Verde" wine.
#' For more details, consult: http://www.vinhoverde.pt/en/ or the reference Cortez et al., 2009.
#'
#' A dataset downloaded from UCI Machine Learning Database
#' archive.ics.uci.edu/ml/machine-learning-databases/wine-quality/winequality-white.cs
#'
#' \itemize{
#'    \item fixed.acidity
#'    \item volatile.acidity
#'    \item citric.acid
#'    \item residual.sugar
#'    \item chlorides
#'    \item free.sulfur.dioxide
#'    \item total.sulfur.dioxide
#'    \item density
#'    \item pH
#'    \item sulphates
#'    \item alcohol
#'    \item quality
#' }
#'
#' @name wine
#' @format A data frame with 4898 rows and 12 variables
#' @source   P. Cortez, A. Cerdeira, F. Almeida, T. Matos and J. Reis.
#' Modeling wine preferences by data mining from physicochemical properties.
#' In Decision Support Systems, Elsevier, 47(4):547-553. ISSN: 0167-9236.

NULL
