% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TGUH.R
\name{sol.tguh}
\alias{sol.tguh}
\title{Solution path generation via the Tail-Greedy Unbalanced Haar method}
\usage{
sol.tguh(x, type = "const", p = 0.01)
}
\arguments{
\item{x}{A numeric vector containing the data to be processed}

\item{type}{The model type considered. \code{type = "const"} means piecewise-constant; this is the only type currently supported in \code{sol.tguh}}

\item{p}{Specifies the number of region pairs merged 
in each pass through the data, as the proportion of all remaining region pairs. The default is
\code{p = 0.01}}
}
\value{
An S3 object of class \code{cptpath}, which contains the following fields: 
\item{solutions.nested}{\code{TRUE}, i.e., the change-point outputs are nested}
\item{solution.path}{Locations of possible change-points in the mean of \code{x}, arranged in decreasing order of change-point importance}
\item{solution.set}{Empty list}
\item{x}{Input vector \code{x}}
\item{type}{Input parameter \code{type}}
\item{p}{Input parameter \code{p}}
\item{cands}{Matrix of dimensions length(\code{x}) - 1 by 4. The first two columns are (start, end)-points of the detection intervals of the corresponding possible change-point location in the third column. The fourth column is a measure of strength of the corresponding possible change-point. The order of the rows is the same as the order returned in \code{solution.path}}
\item{method}{The method used, which has value "tguh" here}
}
\description{
This function arranges all possible change-points in the mean of the input vector in the order of importance, via the Tail-Greedy Unbalanced Haar method.
}
\details{
The Tail-Greedy Unbalanced Haar decomposition algorithm is described in 
"Tail-greedy bottom-up data decompositions and fast multiple change-point 
detection", P. Fryzlewicz (2018), The Annals of Statistics, 46, 3390--3421.
}
\examples{
r3 <- rnorm(1000) + c(rep(0,300), rep(2,200), rep(-4,300), rep(0,200))
sol.tguh(r3)
}
\references{
P. Fryzlewicz (2018). Tail-greedy bottom-up data decompositions and fast multiple change-point detection. \emph{The Annals of Statistics}, 46, 3390--3421.
}
\seealso{
\code{\link{sol.idetect}}, \code{\link{sol.idetect_seq}}, \code{\link{sol.not}}, \code{\link{sol.wbs}}, \code{\link{sol.wbs2}}
}
