% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/execution-context.R
\name{db_context_create}
\alias{db_context_create}
\title{Create an Execution Context}
\usage{
db_context_create(
  cluster_id,
  language = c("python", "sql", "scala", "r"),
  host = db_host(),
  token = db_token(),
  perform_request = TRUE
)
}
\arguments{
\item{cluster_id}{The ID of the cluster to create the context for.}

\item{language}{The language for the context. One of \code{python}, \code{sql}, \code{scala},
\code{r}.}

\item{host}{Databricks workspace URL, defaults to calling \code{\link[=db_host]{db_host()}}.}

\item{token}{Databricks workspace token, defaults to calling \code{\link[=db_token]{db_token()}}.}

\item{perform_request}{If \code{TRUE} (default) the request is performed, if
\code{FALSE} the httr2 request is returned \emph{without} being performed.}
}
\description{
Create an Execution Context
}
\seealso{
Other Execution Context API: 
\code{\link{db_context_command_cancel}()},
\code{\link{db_context_command_parse}()},
\code{\link{db_context_command_run}()},
\code{\link{db_context_command_run_and_wait}()},
\code{\link{db_context_command_status}()},
\code{\link{db_context_destroy}()},
\code{\link{db_context_status}()}
}
\concept{Execution Context API}
