% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uc-volumes.R
\name{db_uc_volumes_update}
\alias{db_uc_volumes_update}
\title{Update Volume (Unity Catalog)}
\usage{
db_uc_volumes_update(
  catalog,
  schema,
  volume,
  owner = NULL,
  comment = NULL,
  new_name = NULL,
  host = db_host(),
  token = db_token(),
  perform_request = TRUE
)
}
\arguments{
\item{catalog}{Parent catalog of volume}

\item{schema}{Parent schema of volume}

\item{volume}{Volume name.}

\item{owner}{The identifier of the user who owns the volume (Optional).}

\item{comment}{The comment attached to the volume (Optional).}

\item{new_name}{New name for the volume (Optional).}

\item{host}{Databricks workspace URL, defaults to calling \code{\link[=db_host]{db_host()}}.}

\item{token}{Databricks workspace token, defaults to calling \code{\link[=db_token]{db_token()}}.}

\item{perform_request}{If \code{TRUE} (default) the request is performed, if
\code{FALSE} the httr2 request is returned \emph{without} being performed.}
}
\value{
List
}
\description{
Update Volume (Unity Catalog)
}
\seealso{
Other Unity Catalog Volume Management: 
\code{\link{db_uc_volumes_create}()},
\code{\link{db_uc_volumes_delete}()},
\code{\link{db_uc_volumes_get}()},
\code{\link{db_uc_volumes_list}()}
}
\concept{Unity Catalog Volume Management}
