% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{BridgeRCore}
\alias{BridgeRCore}
\title{BridgeR basic function for calculating RNA half-life from BRIC-seq data}
\usage{
BridgeRCore(inputFile, inforColumn = 4, group = c("Control", "Knockdown"),
  hour = c(0, 1, 2, 4, 8, 12), RPKMcutoff = 0.1, cutoffBelow = 0.1,
  YMin = -2, YMax = 2, downsamplingFig = 0.2, makeFig = FALSE,
  cutoffQuantile = 0.975, inforHKGenesRow = "symbol", HKGenes = c("GAPDH",
  "PGK1", "PPIA", "ENO1", "ATP5B", "ALDOA"), CutoffTimePointNumber = 4,
  R2_criteria = 0.9, TimePointRemoval1 = c(1, 2), TimePointRemoval2 = c(8,
  12), ThresholdHalfLife1 = 3, ThresholdHalfLife2 = 12, save = TRUE,
  outputPrefix = "BridgeR", normalization = "default", method = "default")
}
\arguments{
\item{inputFile}{The vector of tab-delimited matrix file.}

\item{inforColumn}{The number of information columns.}

\item{group}{The vector of group names.}

\item{hour}{The vector of time course about BRIC-seq experiment.}

\item{RPKMcutoff}{Cutoff value of RPKM at 0hr.}

\item{cutoffBelow}{Cutoff value of RPKM at all time points.}

\item{YMin}{Y-axis min.}

\item{YMax}{Y-axis max.}

\item{downsamplingFig}{the factor for downsampling.}

\item{makeFig}{Whether to save the figure of normalization factor.}

\item{cutoffQuantile}{cutoff value of quantile.#' @param save Whether to save the output matrix file.}

\item{inforHKGenesRow}{The column number of house-keeping gene information.}

\item{HKGenes}{The vector of house-keeping genes.}

\item{CutoffTimePointNumber}{The number of minimum time points for calc.}

\item{R2_criteria}{The cutoff of R2 for R2 selection.}

\item{TimePointRemoval1}{The candicate_1 of time point removal.}

\item{TimePointRemoval2}{The candicate_2 of time point removal.}

\item{ThresholdHalfLife1}{The cutoff of TimePointRemoval1.}

\item{ThresholdHalfLife2}{The cutoff of TimePointRemoval2.}

\item{save}{Whether to save the output matrix file.}

\item{outputPrefix}{The prefix for the name of the output.}

\item{normalization}{select "default" (percentile method) or "house_keeping_genes"}

\item{method}{select "default" (R2 selection/1st-order) or "3models".}
}
\value{
data.table object including RNA half-life, R2 and the selected fitting model.
}
\description{
\code{BridgeRCore} is a basic function for calculating RNA half-life
BRIC-seq data and a wrapper of the other individual bridger2 functions.
}
\examples{
halflife_table <- BridgeRCore(RNA_halflife_comparison[1:30,],
                              save = FALSE)
halflife_table <- BridgeRCore(RNA_halflife_comparison_HK[177:206],
                              save = FALSE,
                              normalization = "house_keeping_genes",
                              method = "3models")

}

