% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nearests.R
\name{near_between}
\alias{near_between}
\title{Return x percent to y percent of values}
\usage{
near_between(x, from, to)
}
\arguments{
\item{x}{numeric vector}

\item{from}{the lower bound of percentage}

\item{to}{the upper bound of percentage}
}
\value{
logical vector
}
\description{
Return x percent to y percent of values
}
\examples{
x <- runif(20)

near_middle(x = x,
            middle = 0.5,
            within = 0.2)

library(dplyr)
heights \%>\% features(height_cm, list(min = min)) \%>\%
  filter(near_between(min, 0.1, 0.9))

near_quantile(x = x,
              probs = 0.5,
              tol = 0.01)

near_quantile(x, c(0.25, 0.5, 0.75), 0.05)

heights \%>\%
  features(height_cm, l_five_num) \%>\%
  mutate_at(vars(min:max),
            .funs = near_quantile,
            0.5,
            0.01) \%>\%
  filter(min)

heights \%>\%
  features(height_cm, list(min = min)) \%>\%
  mutate(min_near_q3 = near_quantile(min, c(0.25, 0.5, 0.75), 0.01)) \%>\%
  filter(min_near_q3)

heights \%>\%
  features(height_cm, list(min = min)) \%>\%
  filter(near_between(min, 0.1, 0.9))

heights \%>\%
  features(height_cm, list(min = min)) \%>\%
  filter(near_middle(min, 0.5, 0.1))
}
