% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nearests.R
\name{nearests}
\alias{nearests}
\alias{nearest_lgl}
\alias{nearest_qt_lgl}
\title{Is x nearest to y?}
\usage{
nearest_lgl(x, y)

nearest_qt_lgl(y, ...)
}
\arguments{
\item{x}{a numeric vector}

\item{y}{a numeric vector}

\item{...}{(if used) arguments to pass to \code{quantile()}.}
}
\value{
logical vector of \code{length(y)}
}
\description{
Returns TRUE if x is nearest to y.
There are two implementations. \code{nearest_lgl()} returns a logical vector
when an element of the first argument is nearest to an element of the
second argument. \code{nearest_qt_lgl()} is similar to \code{nearest_lgl()}, but
instead determines if an element of the first argument is nearest to
some value of the given quantile probabilities. See example for more
detail.
}
\examples{

x <- 1:10
y <- 5:14
z <- 16:25
a <- -1:-5
b <- -1

nearest_lgl(x, y)
nearest_lgl(y, x)

nearest_lgl(x, z)
nearest_lgl(z, x)

nearest_lgl(x, a)
nearest_lgl(a, x)

nearest_lgl(x, b)
nearest_lgl(b, x)

library(dplyr)
heights_near_min <- heights \%>\%
  filter(nearest_lgl(min(height_cm), height_cm))

heights_near_fivenum <- heights \%>\%
  filter(nearest_lgl(fivenum(height_cm), height_cm))

heights_near_qt_1 <- heights \%>\%
  filter(nearest_qt_lgl(height_cm, c(0.5)))

heights_near_qt_3 <- heights \%>\%
  filter(nearest_qt_lgl(height_cm, c(0.1, 0.5, 0.9)))

}
