% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bruceR-stats_1_basic.R
\name{cor_diff}
\alias{cor_diff}
\title{Test the difference between two correlations.}
\usage{
cor_diff(r1, n1, r2, n2, n = NULL, rcov = NULL)
}
\arguments{
\item{r1, r2}{Correlation coefficients (Pearson's \eqn{r}).}

\item{n, n1, n2}{Sample sizes.}

\item{rcov}{[Optional] Only for nonindependent \eqn{r}s:

\code{r1} is r(X,Y),

\code{r2} is r(X,Z),

then, as Y and Z are also correlated,

we should also consider \code{rcov}: r(Y,Z)}
}
\value{
Invisibly return the \emph{p} value.
}
\description{
Test the difference between two correlations.
}
\examples{
# two independent rs (X~Y vs. Z~W)
cor_diff(r1=0.20, n1=100, r2=0.45, n2=100)

# two nonindependent rs (X~Y vs. X~Z, with Y and Z also correlated [rcov])
cor_diff(r1=0.20, r2=0.45, n=100, rcov=0.80)

}
