% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unpack.R
\name{unpack}
\alias{unpack}
\title{unpack: Unpack Stan output for factor analysis samples from Stan}
\usage{
unpack(Samples, Format)
}
\arguments{
\item{Samples}{S by theta matrix of sample parameter estimates.}

\item{Format}{list formatted data file provided for Stan}
}
\value{
Returns four matrices:

1). S by Q latent score matrix, x.

2). S by Q*P loading matrix, lambda.

3). S by P mean matrix, tau.

4). S by P loading variance matrix, alpha.
}
\description{
This function unpacks raw Stan samples output.
}
\examples{
\dontrun{
your_data_s=standardize(your_data)
formatted_data=prep(your_data_s,nfactors=3)
out=sampling(model, data=formatted_data, iter=5000, seed=999)
res=as.matrix(out)


unpacked=unpack(Samples=res,Format=formatted_data)}


}
