% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/useful-items.R, R/aliases.R
\name{bs4Callout}
\alias{bs4Callout}
\alias{callout}
\title{Create a Bootstrap 4 callout}
\usage{
bs4Callout(
  ...,
  title,
  status = c("warning", "danger", "info", "success"),
  width = 6,
  elevation = NULL
)

callout(
  ...,
  title,
  status = c("warning", "danger", "info", "success"),
  width = 6,
  elevation = NULL
)
}
\arguments{
\item{...}{Callout content.}

\item{title}{Callout title.}

\item{status}{Callout status. Valid statuses:
\itemize{
\item \code{info}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#17a2b8")}.
\item \code{success}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#28a745")}.
\item \code{warning}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#ffc107")}.
\item \code{danger}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#dc3545")}.
}}

\item{width}{Callout width. Between 1 and 12.}

\item{elevation}{Callout elevation.}
}
\description{
AdminLTE3 callout
}
\examples{
if(interactive()){
 library(shiny)
 library(bs4Dash)

 shinyApp(
   ui = dashboardPage(
     header = dashboardHeader(),
     sidebar = dashboardSidebar(),
     controlbar = dashboardControlbar(),
     footer = dashboardFooter(),
     title = "Callout",
     body = bs4DashBody(
       title = "Callouts",
       callout(
        title = "I am a danger callout!",
        elevation = 4,
        status = "danger",
        "There is a problem that we need to fix.
        A wonderful serenity has taken possession of
        my entire soul, like these sweet mornings of
        spring which I enjoy with my whole heart."
       ),
       callout(
        title = "I am a danger callout!",
        status = "warning",
        "This is a yellow callout."
       )
     )
   ),
   server = function(input, output) {}
 )
}

}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
