% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render-functions.R
\name{renderMenu}
\alias{renderMenu}
\title{Create dynamic menu output (server side)}
\usage{
renderMenu(expr, env = parent.frame(), quoted = FALSE, outputArgs = list())
}
\arguments{
\item{expr}{An expression that returns a Shiny tag object, \code{\link[shiny:HTML]{HTML()}},
or a list of such objects.}

\item{env}{The parent environment for the reactive expression. By default,
this is the calling environment, the same as when defining an ordinary
non-reactive expression. If \code{expr} is a quosure and \code{quoted} is \code{TRUE},
then \code{env} is ignored.}

\item{quoted}{If it is \code{TRUE}, then the \code{\link[=quote]{quote()}}ed value of \code{expr}
will be used when \code{expr} is evaluated. If \code{expr} is a quosure and you
would like to use its expression as a value for \code{expr}, then you must set
\code{quoted} to \code{TRUE}.}

\item{outputArgs}{A list of arguments to be passed through to the implicit
call to \code{\link[shiny:uiOutput]{uiOutput()}} when \code{renderUI} is used in an
interactive R Markdown document.}
}
\description{
Create dynamic menu output (server side)
}
\examples{
## Only run these examples in interactive R sessions

if (interactive()) {
  library(shiny)
  library(bs4Dash)
  messageData <- data.frame(
    from = c("Admininstrator", "New User", "Support"),
    message = c(
      "Sales are steady this month.",
      "How do I register?",
      "The new server is ready."
    ),
    stringsAsFactors = FALSE
  )

  # ========== Dynamic dropdownMenu ==========
  ui <- dashboardPage(
    dashboardHeader(
      title = "Dynamic menus",
      dropdownMenuOutput("messageMenu")
    ),
    dashboardSidebar(),
    dashboardBody(
      fluidRow(
        box(
          title = "Controls",
          sliderInput("slider", "Number of observations:", 1, 100, 50)
        )
      )
    )
  )

  server <- function(input, output) {
    output$messageMenu <- renderMenu({
      # Code to generate each of the messageItems here, in a list. messageData
      # is a data frame with two columns, 'from' and 'message'.
      # Also add on slider value to the message content, so that messages update.
      msgs <- apply(messageData, 1, function(row) {
        messageItem(
          from = row[["from"]],
          message = paste(row[["message"]], input$slider)
        )
      })

      dropdownMenu(type = "messages", .list = msgs)
    })
  }

  shinyApp(ui, server)


  # ========== Dynamic sidebarMenu ==========
  ui <- dashboardPage(
    dashboardHeader(title = "Dynamic sidebar"),
    dashboardSidebar(
      sidebarMenuOutput("menu")
    ),
    dashboardBody()
  )

  server <- function(input, output) {
    output$menu <- renderMenu({
      sidebarMenu(
        menuItem("Menu item", icon = icon("calendar-days"))
      )
    })
  }

  shinyApp(ui, server)
}
}
\seealso{
\code{\link{menuOutput}} for the corresponding client side function
and examples.

Other menu outputs: 
\code{\link{dropdownMenuOutput}()},
\code{\link{menuItemOutput}()},
\code{\link{menuOutput}()},
\code{\link{sidebarMenuOutput}()}
}
\concept{menu outputs}
