% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bsnsing.R
\name{plot.bsnsing}
\alias{plot.bsnsing}
\title{Generate latex code for plotting a bsnsing tree}
\usage{
\method{plot}{bsnsing}(
  x,
  file = "",
  class_labels = c(),
  class_colors = c("red", "green"),
  rule_font = c("footnotesize", "scriptsize", "tiny", "normalsize", "small"),
  rule_color = "blue",
  footnote = FALSE,
  landscape = FALSE,
  papersize = c("a0paper", "a1paper", "a2paper", "a3paper", "a4paper", "a5paper",
    "a6paper", "b0paper", "b1paper", "b2paper", "b3paper", "b4paper", "b5paper",
    "b6paper", "c0paper", "c1paper", "c2paper", "c3paper", "c4paper", "c5paper",
    "c6paper", "b0j", "b1j", "b2j", "b3j", "b4j", "b5j", "b6j", "ansiapaper",
    "ansibpaper", "ansicpaper", "ansidpaper", "ansiepaper", "letterpaper",
    "executivepaper", "legalpaper"),
  verbose = FALSE,
  ...
)
}
\arguments{
\item{x}{an object of class \code{\link{bsnsing}}.}

\item{file}{a writable connection or a character string naming the file to write to. If not supplied, the output will be written to the console.}

\item{class_labels}{a character vector of two elements for leaf node label (for 0 and 1). If empty, the labels will be read from the bsnsing object.}

\item{class_colors}{a character vector of two elements for leaf node color (for 0 and 1)}

\item{rule_font}{a string specifying the font size of the split rule at each non-leaf node}

\item{rule_color}{a string specifying the color of the split rule and node, e.g., blue, gray, black, etc. For a list of all usable colors, see https://en.wikibooks.org/wiki/LaTeX/Colors}

\item{footnote}{a boolean value indicating whether to add annotation text to the PDF page. The default is FALSE.}

\item{landscape}{a boolean value indicating if the PDF page should be in landscape layout. The default is FALSE.}

\item{papersize}{a string specifying the PDF paper size. The default is 'a0paper'.}

\item{verbose}{a logical value, default is FALSE.}

\item{...}{further parameters to the plot function.}
}
\value{
No return value.
}
\description{
If the file argument is supplied, this function will invoke the external programs latex, dvips and ps2pdf. If these programs are not available, only the latex code will be generated. If the file argument is left empty, the latex code will be written to the console screen. The latex code utilizes the following  packages: pstricks, pst-node, pst-tree.
}
\examples{
bs <- bsnsing(Class ~ ., data = GlaucomaMVF)
plot(bs)
\dontrun{
plot(bs, file = 'GlaucomaMVF_tree.pdf')
plot(bs, file = 'GlaucomaMVF_tree_letterpaper.pdf', paper='letterpaper')
}
}
