% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bspline.R
\docType{package}
\name{bspline}
\alias{bspline-package}
\alias{bspline}
\title{bspline: build and use B-splines for interpolation and regression.}
\description{
Build and use B-splines for interpolation and regression.
  In case of regression, equality constraints as well as monotonicity
  requirement can be imposed. Moreover, 
  knot positions (not only spline coefficients) can be part of 
  optimized parameters too. User is provided with 
  functions calculating spline values at arbitrary points. This 
  functions can be differentiated to obtain B-splines calculating 
  derivatives at any point. B-splines of this package can 
  simultaneously operate on a series of curves sharing the same set of 
  knots. 'bspline' is written with concern about computing 
  performance that's why the basis calculation is implemented in C++.
  The rest is implemented in R but without notable impact on computing speed.
}
\section{bspline functions}{
 \describe{
 \item{\code{bsc}:}{ basis matrix (implemented in C++)}
 \item{\code{bsp}:}{ values of B-spline from its coefficients}
 \item{\code{dbsp}:}{ derivative of B-spline}
 \item{\code{par2bsp}:}{ build B-spline function from parameters }
 \item{\code{bsppar}:}{ retrieve B-spline parameters from its function}
 \item{\code{smbsp}:}{ build smoothing B-spline}
 \item{\code{fitsmbsp}:}{ build smoothing B-spline with optimized knot positions}
 \item{\code{diffn}:}{ finite differences}
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/MathsCell/bspline}
  \item Report bugs at \url{https://github.com/MathsCell/bspline/issues}
}

}
\author{
\strong{Maintainer}: Serguei Sokol \email{sokol@insa-toulouse.fr}

}
