% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_conditional_sd.R
\name{compute_conditional_sd.PosteriorBSVART}
\alias{compute_conditional_sd.PosteriorBSVART}
\title{Computes posterior draws of structural shock conditional standard deviations}
\usage{
\method{compute_conditional_sd}{PosteriorBSVART}(posterior)
}
\arguments{
\item{posterior}{posterior estimation outcome - an object of class 
\code{PosteriorBSVART} obtained by running the \code{estimate} function.}
}
\value{
An object of class \code{PosteriorSigma}, that is, an \code{NxTxS} 
array with attribute \code{PosteriorSigma} containing \code{S} draws of the 
structural shock conditional standard deviations.
}
\description{
Each of the draws from the posterior estimation of models is 
transformed into a draw from the posterior distribution of the structural 
shock conditional standard deviations.
}
\examples{
# upload data
data(us_fiscal_lsuw)

# specify the model and set seed
set.seed(123)
specification  = specify_bsvar_t$new(us_fiscal_lsuw, p = 1)

# run the burn-in
burn_in        = estimate(specification, 10)

# estimate the model
posterior      = estimate(burn_in, 20)

# compute structural shocks' conditional standard deviations
sigma          = compute_conditional_sd(posterior)

# workflow with the pipe |>
############################################################
set.seed(123)
us_fiscal_lsuw |>
  specify_bsvar_t$new(p = 1) |>
  estimate(S = 10) |> 
  estimate(S = 20) |> 
  compute_conditional_sd() -> csd

}
\seealso{
\code{\link{estimate}}, \code{\link{normalise_posterior}}, \code{\link{summary}}
}
\author{
Tomasz Woźniak \email{wozniak.tom@pm.me}
}
