% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pair_methods.R
\name{pair_ace}
\alias{pair_ace}
\title{Alternating conditional expectations correlation}
\usage{
pair_ace(d, handle.na = TRUE, warnings = TRUE, ...)
}
\arguments{
\item{d}{A dataframe}

\item{handle.na}{If TRUE uses pairwise complete observations, otherwise NAs not handled.}

\item{warnings}{If TRUE, generates a warning for datasets of one row, one column, or with constant variables.}

\item{...}{other arguments}
}
\value{
A tibble of class \code{pairwise} with a maximal correlation  from the alternating conditional expectations
algorithm for every variable pair
}
\description{
Calculates the maximal correlation coefficient from alternating conditional expectations algorithm for every variable pair in a dataset.
}
\details{
The maximal correlation is calculated using alternating conditional expectations
algorithm which find the transformations of variables such that the squared correlation
is maximised. The \code{\link[acepack]{ace}} function from \code{acepack} package is used for the
calculation.
}
\examples{
pair_ace(iris)
}
\references{
Breiman, Leo, and Jerome H. Friedman.
"Estimating optimal transformations for multiple regression and correlation."
Journal of the American statistical Association 80.391 (1985): 580-598.
}
