% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot.bumbldf}
\alias{plot.bumbldf}
\title{Plot observed and fitted results from bumbl()}
\usage{
\method{plot}{bumbldf}(x, ..., colony = NULL)
}
\arguments{
\item{x}{a dataframe produced by \code{\link[=bumbl]{bumbl()}}.}

\item{...}{other arguments not used by this method.}

\item{colony}{optional vector of colony ID's (character) or indexes (numeric) to plot.  If not supplied, all colonies will be plotted.}
}
\value{
invisibly returns a list of dataframes used for building the plots.
}
\description{
Creates one plot per level of colonyID showing the observed (points) and fitted (red line) values from the model implemented by \code{bumbl()}.
}
\examples{
set.seed(687)
colonyID_subset <- sample(bombus$colony, 10)
colony_subset <- bombus[bombus$colony \%in\% colonyID_subset, ]
results <- bumbl(colony_subset, colonyID = colony, t = week,
                 formula = mass ~ week)
plot(results)
}
\seealso{
\code{\link[=bumbl]{bumbl()}}, \code{\link[=autoplot.bumbldf]{autoplot.bumbldf()}}
}
