% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapt_autobahn.R
\name{autobahn_roadwork_details}
\alias{autobahn_roadwork_details}
\title{Get Autobahn roadwork details}
\usage{
autobahn_roadwork_details(roadwork_id, flatten = FALSE, flatten_mode = "json")
}
\arguments{
\item{roadwork_id}{Roadwork identifier.}

\item{flatten}{Logical; drop nested list columns.}

\item{flatten_mode}{Flatten strategy for list columns. Use "unnest" to
expand list-columns into multiple rows.}
}
\value{
A tibble with roadwork details.
}
\description{
Get Autobahn roadwork details
}
\details{
Returns full details for a single roadwork entry.
Official docs: https://autobahn.api.bund.dev.
}
\examples{
\dontrun{
roads <- autobahn_roads()
roadworks <- autobahn_roadworks(roads$road_id[[1]])
autobahn_roadwork_details(roadworks$identifier[[1]])
}
}
\seealso{
\code{\link[=autobahn_roadworks]{autobahn_roadworks()}} to list roadworks.
}
