% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapt_nina.R
\name{nina_warning_json}
\alias{nina_warning_json}
\title{Get a NINA warning (JSON)}
\usage{
nina_warning_json(identifier, safe = TRUE, refresh = FALSE)
}
\arguments{
\item{identifier}{Warning identifier.}

\item{safe}{Logical; apply throttling and caching.}

\item{refresh}{Logical; refresh cached responses.}
}
\value{
A tibble with warning details.

Includes \code{sent_time} as POSIXct in Europe/Berlin.
}
\description{
Get a NINA warning (JSON)
}
\details{
Returns a warning in JSON format.
}
\examples{
\dontrun{
map <- nina_mapdata("mowas")
nina_warning_json(map$id[[1]])
}

}
\seealso{
\code{\link[=nina_mapdata]{nina_mapdata()}} to discover identifiers.
}
