## -----------------------------------------------------------------------------
analogsea::droplet_ssh(droplet, "journalctl -u server-myapp -n 50")


## -----------------------------------------------------------------------------
analogsea::droplet_ssh(droplet, "systemctl status server-myapp")


## -----------------------------------------------------------------------------
# Refresh droplet information
droplet <- analogsea::droplet(droplet$id)

# Check IP is accessible
ip <- analogsea::droplet_ip(droplet)
system(paste("ping -c 3", ip))


## -----------------------------------------------------------------------------
# Check if the service is running
analogsea::droplet_ssh(droplet, "systemctl status server-myapp")

# Check if nginx is running
analogsea::droplet_ssh(droplet, "systemctl status nginx")


## -----------------------------------------------------------------------------
# View recent logs
analogsea::droplet_ssh(droplet, "journalctl -u server-myapp -n 50")

# Follow logs in real-time
analogsea::droplet_ssh(droplet, "journalctl -u server-myapp -f")


## -----------------------------------------------------------------------------
# Install missing packages via pak
analogsea::droplet_ssh(
  droplet,
  "R -e 'pak::pkg_install(c(\"missingpkg1\", \"missingpkg2\"))'"
)

# Or install system dependencies directly if needed
analogsea::ubuntu_apt_get_install(droplet, "libcurl4-openssl-dev")
analogsea::ubuntu_apt_get_install(droplet, c("libxml2-dev", "libssl-dev"))


## -----------------------------------------------------------------------------
# Check what's using the port
analogsea::droplet_ssh(droplet, "netstat -tlnp | grep 8000")

# Use a different port for your application
do_deploy_server(droplet, "myapp", "path/to/app", port = 8001)


## -----------------------------------------------------------------------------
# Check your _server.yml syntax
validate_server_yml("my-app", check_engine = TRUE, verbose = TRUE)

# Read and inspect configuration
config <- read_server_yml("my-app")
str(config)


## -----------------------------------------------------------------------------
# List all server services
analogsea::droplet_ssh(droplet, "systemctl list-units | grep server-")

# Check specific service status
analogsea::droplet_ssh(droplet, "systemctl status server-myapp")


## -----------------------------------------------------------------------------
# Restart the service
analogsea::droplet_ssh(droplet, "sudo systemctl restart server-myapp")

# Check status after restart
analogsea::droplet_ssh(droplet, "systemctl status server-myapp")


## -----------------------------------------------------------------------------
# Test nginx configuration for syntax errors
analogsea::droplet_ssh(droplet, "nginx -t")

# If errors, view the configuration
analogsea::droplet_ssh(droplet, "cat /etc/nginx/sites-available/server-myapp")


## -----------------------------------------------------------------------------
# Check nginx error log
analogsea::droplet_ssh(droplet, "tail -f /var/log/nginx/error.log")

# Check nginx access log
analogsea::droplet_ssh(droplet, "tail -f /var/log/nginx/access.log")


## -----------------------------------------------------------------------------
# Restart nginx
analogsea::droplet_ssh(droplet, "sudo systemctl restart nginx")

# Check status
analogsea::droplet_ssh(droplet, "systemctl status nginx")


## -----------------------------------------------------------------------------
# Basic validation
validate_server_yml("my-app")

# Validate and check that engine is installed locally
validate_server_yml("my-app", check_engine = TRUE)

# Verbose output for debugging
validate_server_yml("my-app", check_engine = TRUE, verbose = TRUE)


## -----------------------------------------------------------------------------
# Check SSH connection
analogsea::droplet_ssh(droplet, "echo 'Connection works'")

# Check available disk space
analogsea::droplet_ssh(droplet, "df -h")

# Try deploying again with overwrite
do_deploy_server(droplet, "myapp", "path/to/app", port = 8000, overwrite = TRUE)


## -----------------------------------------------------------------------------
# Check R is installed
analogsea::droplet_ssh(droplet, "R --version")

# Try installing the package manually
analogsea::install_r_package(droplet, "plumber2")


## -----------------------------------------------------------------------------
# Check certbot logs
analogsea::droplet_ssh(droplet, "cat /var/log/letsencrypt/letsencrypt.log")

# Verify DNS is configured correctly
# (must wait for DNS propagation, usually 5-60 minutes)
system(paste("nslookup", "api.yourdomain.com"))


## -----------------------------------------------------------------------------
# Test certificate renewal
analogsea::droplet_ssh(droplet, "sudo certbot renew --dry-run")

# Check renewal timer status
analogsea::droplet_ssh(droplet, "systemctl status certbot.timer")


## -----------------------------------------------------------------------------
# Check memory usage
analogsea::droplet_ssh(droplet, "free -h")

# Check which processes are using memory
analogsea::droplet_ssh(droplet, "ps aux --sort=-%mem | head -n 10")

# Consider upgrading to a larger droplet
droplet <- do_provision(size = "s-2vcpu-4gb")


## -----------------------------------------------------------------------------
# Check CPU usage
analogsea::droplet_ssh(droplet, "top -bn1 | head -20")

# Check if application is under heavy load
analogsea::droplet_ssh(
  droplet,
  "journalctl -u server-myapp -n 100 | grep -i error"
)


## -----------------------------------------------------------------------------
analogsea::droplet_ssh(droplet, "echo 'Connected'")


## -----------------------------------------------------------------------------
analogsea::droplet_ssh(droplet, "systemctl status server-myapp")


## -----------------------------------------------------------------------------
analogsea::droplet_ssh(droplet, "journalctl -u server-myapp -n 50")


## -----------------------------------------------------------------------------
analogsea::droplet_ssh(droplet, "netstat -tlnp | grep 8000")


## -----------------------------------------------------------------------------
analogsea::droplet_ssh(droplet, "nginx -t && systemctl status nginx")


## -----------------------------------------------------------------------------
validate_server_yml("my-app", check_engine = TRUE, verbose = TRUE)

