% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permalink2list.R
\name{permalink2list}
\alias{permalink2list}
\title{Turn a Shiny permalink into a list}
\usage{
permalink2list(permalink, prefix = ".*\\\\?_inputs_&")
}
\arguments{
\item{permalink}{Character string,
      the actual URL with arguments copied from the Shiny app as-is.}

\item{prefix}{Character string or regular expression,
      should capture everything up to the first argument name.
This is the part that will be discarded.}
}
\value{
A named list with one element for each argument in \code{permalink}.
}
\description{
The Shiny package can generate permalinks of its web apps,
      making it possible to share individual configurations
of the app with others. This function translated such a permalink into a named list,
      so you can use the configuration
also in R code.
}
\details{
When this package was written,
      we also wrote a Shiny web app for it but separated the actual calculations from the app's code.
This allowed us to use the same functions and objects in RMarkdown. We were discussing the numbers in the web tool
using permalinks, and finally transferred the calculations to the PDF version.

To transfer the configuration from the web app to the markdown document,
      this function discards the URL prefix and splits
the arguments into a named list that behaves like the input object commonly used in Shiny apps.
}
\examples{
permalink2list(
  paste0(
    "https://example.com/businessPlanR/?_inputs_&salary=50000",
    "&loan_interest=3.22&loan_period=7&loan_due=2&years=\%5B\%222022\%22\%2C\%222026\%22\%5D"
  )
)
}
