% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_shortCallbutterfly.R
\name{shortCallbutterfly}
\alias{shortCallbutterfly}
\title{Calculates per share Profit and Loss (PnL) at expiration for Short Call Butterfly Option Strategy and draws its Bar Plot displaying PnL in the Plots tab.}
\usage{
shortCallbutterfly(
  ST,
  X,
  X1L,
  X3H,
  C,
  C1L,
  C3H,
  hl = 0,
  hu = 2,
  spot = spot,
  pl = pl,
  myData = myData,
  myTibble = myTibble,
  PnL = PnL
)
}
\arguments{
\item{ST}{Spot Price at time T.}

\item{X}{Strike Price or eXercise price for two ATM bought Calls.}

\item{X1L}{Lower Strike Price or eXercise price for one ITM shorted Call.}

\item{X3H}{Higher Strike Price or eXercise price for one OTM shorted Call.}

\item{C}{Call Premium or Call Price paid for the two ATM bought Calls.}

\item{C1L}{Call Premium or Call Price received for the first ITM shorted Call.}

\item{C3H}{Call Premium or Call Price received for the one OTM shorted Call.}

\item{hl}{lower bound value for setting lower-limit of x-axis displaying spot price.}

\item{hu}{upper bound value for setting upper-limit of x-axis displaying spot price.}

\item{spot}{Spot Price}

\item{pl}{Profit and Loss}

\item{myData}{Data frame}

\item{myTibble}{tibble}

\item{PnL}{Profit and Loss}
}
\value{
graph of the strategy
}
\description{
This is a volatility strategy consisting of a short position in an ITM (in the money) call option with a strike price X1L, a long position in two ATM ( at the money) call options with a strike price X, and a short position in an OTM (out of the money) call option with a strike price X3H. The strikes are equidistant: X3H minus X equals to X minus X1L . This is a net credit trade. In this sense, this is an income strategy. The trader or investor has  neutral outlook (Kakushadze & Serur, 2018).
}
\details{
According to conceptual details given by Cohen (2015), and a closed form solution provided by Kakushadze and Serur (2018), this method is developed, and the given examples are created, to compute per share Profit and Loss at expiration for Short Call Butterfly Option Strategy and draw its graph in the Plots tab.
}
\examples{
shortCallbutterfly(400,400,375,425,6,17.5,7.5,hl=0.9,hu=1.1)
}
\references{
Cohen, G. (2015). The Bible of Options Strategies (2nd ed.). Pearson Technology Group.\cr
Kakushadze, Z., & Serur, J. A. (2018, August 17). 151 Trading Strategies. Palgrave Macmillan. https://papers.ssrn.com/sol3/papers.cfm?abstract_id=3247865 \cr
R Graphics Cookbook. (n.d.). Coloring Negative and Positive Bars Differently. https://r-graphics.org/recipe-bar-graph-color-neg \cr
Gross C, Ottolinger P (2016).\emph{ggThemeAssist: Add-in to Customize 'ggplot2' Themes}. R package version 0.1.5, <URL: https://CRAN.R-project.org/package=ggThemeAssist>.
}
\author{
MaheshP Kumar, \email{maheshparamjitkumar@gmail.com}
}
