% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_object_list.R
\name{create_object_list}
\alias{create_object_list}
\title{create_object_list: creates a list of objects used in all butterfly functions}
\usage{
create_object_list(df_current, df_previous, datetime_variable, ...)
}
\arguments{
\item{df_current}{data.frame, the newest/current version of dataset x.}

\item{df_previous}{data.frame, the old version of dataset,
for example x - t1.}

\item{datetime_variable}{string, which variable to use as unique ID to join
\code{df_current} and \code{df_previous}. Usually a "datetime" variable.}

\item{...}{Other \code{waldo::compare()} arguments can be supplied here, such as
\code{tolerance} or \code{max_diffs}. See \code{?waldo::compare()} for a full list.}
}
\value{
A list containing boolean where TRUE indicates no changes to
previous data and FALSE indicates unexpected changes, a dataframe of
the current data without new rows and a dataframe of new rows only
}
\description{
This function creates a list of objects which is used by all of \code{loupe()},
\code{catch()} and \code{release()}.
}
\details{
This function matches two dataframe objects by their unique identifier
(usually "time" or "datetime in a timeseries).

It informs the user of new (unmatched) rows which have appeared, and then
returns a \code{waldo::compare()} call to give a detailed breakdown of changes.

The main assumption is that \code{df_current} and \code{df_previous} are a newer and
older versions of the same data, and that the \code{datetime_variable} variable
name always remains the same. Elsewhere new columns can of appear, and these
will be returned in the report.
}
\examples{
butterfly_object_list <- butterfly::create_object_list(
  butterflycount$february, # New or current dataset
  butterflycount$january, # Previous version you are comparing to
  datetime_variable = "time" # Unique ID variable they have in common
)

butterfly_object_list

# You can pass other `waldo::compare()` options such as tolerance here
butterfly_object_list <- butterfly::create_object_list(
  butterflycount$march, # New or current dataset
  butterflycount$february, # Previous version you are comparing it to
  datetime_variable = "time", # Unique ID variable they have in common
  tolerance = 2
)

butterfly_object_list

}
