% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot.CI3.R
\name{param.boot3}
\alias{param.boot3}
\title{Parametric bootstrap confidence intervals of parameters of 3-parameter Block-Basu
Bivariate Pareto (BBBVPA) distribution}
\usage{
param.boot3(
  data,
  a0.int,
  a1.int,
  a2.int,
  conf.lev = 0.95,
  no.paboot = 100,
  ...
)
}
\arguments{
\item{data}{bivariate observations.}

\item{a0.int}{initial choice of \eqn{\alpha_0}.}

\item{a1.int}{initial choice of \eqn{\alpha_1}.}

\item{a2.int}{initial choice of \eqn{\alpha_2}.}

\item{conf.lev}{confidence level, defult 0.95.}

\item{no.paboot}{number of bootstrap samples, \code{100} (default).}

\item{...}{further arguments to pass to \code{estimates3}.}
}
\value{
A matrix of lower and upper confidence interval limits (in the first and second column respectively).
The matrix rows are labeled by the parameter names (if any) and columns by the corresponding
distribution quantiles.
}
\description{
Parametric bootstrap confidence interval of parameters of 3-parameter BBBVPA distribution.
}
\examples{
dat <- rbb.bvpa(500, 0, 0, 1.0, 1.0, 2.0, 0.4, 0.5)
param.boot3(dat, 2.4, 0.3, 0.6)

}
\author{
Biplab Paul <paul.biplab497@gmail.com> and Arabin Kumar Dey <arabin@iitg.ac.in>
}
