% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/c3dr-package.R
\docType{package}
\name{c3dr-package}
\alias{c3dr}
\alias{c3dr-package}
\title{c3dr: Read and Write C3D Motion Capture Files}
\description{
A wrapper for the 'EZC3D' library to work with C3D motion capture data.
}
\details{
An R package for working with motion capture data based on the C++ library
\href{https://github.com/pyomeca/ezc3d}{EZC3D}. Users can read, process, and write
\href{https://www.c3d.org/}{C3D} files containing biomechanical data.
}
\section{Main functions:}{
\itemize{
\item Use \code{\link[=c3d_read]{c3d_read()}} for the import of C3D data.
\item Use \code{\link[=c3d_data]{c3d_data()}} and \code{\link[=c3d_analog]{c3d_analog()}} for retrieving the point and the analog
data as a data frame.
\item Use \code{\link[=c3d_write]{c3d_write()}} to write a c3d object to a C3D file.
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/ropensci/c3dr}
  \item \url{https://docs.ropensci.org/c3dr/}
  \item Report bugs at \url{https://github.com/ropensci/c3dr/issues}
}

}
\author{
\strong{Maintainer}: Simon Nolte \email{s.nolte@dshs-koeln.de} (\href{https://orcid.org/0000-0003-1643-1860}{ORCID})

Other contributors:
\itemize{
  \item Benjamin Michaud (Author of included EZC3D library) [copyright holder]
  \item German Sport University Cologne (0189raq88) [funder]
  \item Aymeric Stamm (reviewed the package (v. 0.1.0) for rOpenSci, see <https://github.com/ropensci/software-review/issues/686>) [reviewer]
  \item July Pilowsky (reviewed the package (v. 0.1.0) for rOpenSci, see <https://github.com/ropensci/software-review/issues/686>) [reviewer]
}

}
\keyword{internal}
