% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/defineclassesandfunctions.R
\name{addsupplementary}
\alias{addsupplementary}
\title{Calculate coordinates for supplementary points, with option to add to the currently selected plot.}
\usage{
addsupplementary(
  x,
  supp,
  thing = "columns",
  suppsymbol = "*",
  suppcolour = "blue",
  plotsupp = TRUE,
  varandcat = TRUE
)
}
\arguments{
\item{x}{An object of class \code{\linkS4class{cabootcrsresults}}}

\item{supp}{A data frame in the format:\cr
SCA supplementary rows: each row is a supplementary row category, the columns are the same as in the original data,
each cell value is the cross-classified count.\cr
SCA supplementary columns: each row is a supplementary column category, the columns are the same as the rows in the original data,
each cell value is the cross-classified count.\cr
MCA supplementary variables: each row is the same individual as in the original data, each column is a supplementary variable,
each cell value is the category which that individual belongs to.}

\item{thing}{Whether to calculate the supplementary principal coordinates for
\describe{
\item{"rows"}{rows, or}
\item{"columns"}{columns}
}
Note that "rows" is only needed for supplementary rows in SCA.}

\item{suppsymbol}{The plot symbol used for the supplementary points}

\item{suppcolour}{The colour of the supplementary points and their labels}

\item{plotsupp}{TRUE if you want the points plotted on the currently active graph, FALSE otherwise}

\item{varandcat}{Flag for how to construct column names for supplementary variables in MCA:
\describe{
\item{TRUE}{if many variables have the same categories, e.g. Likert, column names will be varname:catname}
\item{FALSE}{when variables have distinct categories, column names will just be category names}
}}
}
\value{
A matrix containing the principal coordinates of the supplementary points
}
\description{
\code{addsupplementary} calculates principal coordinate values for supplementary rows or columns in SCA,
or supplementary variables in MCA, then plots them on the current selected graph, which it assumes to be appropriate.
}
\details{
To add supplementary rows in SCA, define the parameter supp as a data frame with one named row for each supplementary row
and with the columns the same as in the original data.\cr
If plotting the points, ensure that the plot for rows is selected.

To add supplementary columns in SCA define the parameter supp as a data frame with one named row for each supplementary column
and with the columns the same as the rows in the original data.\cr
If plotting the points, ensure that the plot for columns is selected.

To add supplementary variables in MCA define the parameter supp as a data frame with one column for each supplementary variable in
individuals by variables format.
Each row represents the same individual as the same row in the original data,
and each entry is the category value for that supplementary variable.
Hence the new columns should just look exactly like new columns in the 'nbyp' format.\cr
If plotting the points, any of the standard plots is suitable.
}
\examples{
results <- cabootcrs(DreamData)
# SCA case two supplementary columns, make sure that the Columns plot is active
suppcols <- data.frame(rbind(c(5,3,6,8,12),c(1,7,3,1,5)))
suppcolpc <- addsupplementary(results, suppcols)
suppcolpc

\dontrun{
# SCA case one supplementary row, make sure that the Rows plot is active
supprow <- data.frame(cbind(12,4,8,3),row.names="supprow")
supprowpc <- addsupplementary(results, supprow, thing="rows")
supprowpc

# MCA case, one or two supplementary variables, plots the same on any of the usual plots
results3 <- cabootcrs(DreamData223by3, catype="mca", varandcat=FALSE,
                      datasetname="Dream data with extra random column")
newsupcol <- c(rep(c(rep("s1",10),rep("s2",10),rep("s3",10)),8))[1:223]
newsupcol2 <- c(rep(c(rep("t1",5),rep("t2",15),rep("t3",25),rep("t4",35)),5))[1:223]
newsupcols <- cbind(newsupcol,newsupcol2)
suppvarpc <- addsupplementary(results3, newsupcol, varandcat=FALSE)
supp2varpc <- addsupplementary(results3, newsupcols, varandcat=FALSE)
}

}
\seealso{
\code{\link{cabootcrs-package}}, \code{\link{cabootcrs}}, \code{\link{plotca}}, \code{\linkS4class{cabootcrsresults}}
}
