% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hebrew.R, R/lunar_calendars_astronomy.R
\name{hebrew_date}
\alias{hebrew_date}
\alias{as_hebrew}
\alias{ohebrew_date}
\alias{as_ohebrew}
\alias{samaritan_date}
\alias{as_samaritan}
\title{Hebrew calendar dates}
\usage{
hebrew_date(year = integer(), month = integer(), day = integer())

as_hebrew(date)

ohebrew_date(year = integer(), month = integer(), day = integer())

as_ohebrew(date)

samaritan_date(year = integer(), month = integer(), day = integer())

as_samaritan(date)
}
\arguments{
\item{year}{A numeric vector of years}

\item{month}{A numeric vector of months}

\item{day}{A numeric vector of days}

\item{date}{Vector of dates on some calendar}
}
\value{
A hebrew vector object
}
\description{
The Hebrew (or Jewish) calendar is an official calendar of Israel, and is used
for Jewish religious holidays. It is a lunisolar calendar comprising months of
29 or 30 days, which begin and end at approximately the time of the new moon.
An extra lunar month is added every 2 or 3 years, so the calendar has either 12
or 13 months per year.
}
\details{
The observational Hebrew calendar ("ohebrew") is the classical calendar where the
new month began with the reported observation of the crescent new moon. In this
implementation, Haifa is taken as the point of observation.

The Samaritan calendar is similar, but the moment of new moon marking the start of
each new month is based on a traditional reckoning of the lunar cycle,
}
\examples{
heb <- new_date(year = 5785, month = 3, day = 2:4, calendar = cal_hebrew)
heb
hebrew_date(5785, 3, 2:4)
as_date(heb, calendar = cal_gregorian)
as_date(Sys.Date(), calendar = cal_hebrew)
tibble::tibble(
  gregorian = gregorian_date(2025, 1, 1) + 0:364,
  hebrew = as_date(gregorian, calendar = cal_hebrew),
)
as_gregorian(hebrew_date(5785, 3, 2:4))
as_hebrew(gregorian_date(2025, 1, 1:31))
as_hebrew("2016-01-01")
as_hebrew(Sys.Date())
hebrew_date(5785, 3, 1:10) |> day_of_week()
}
\seealso{
\link{cal_hebrew}, \link{rosh_hashanah}
}
