% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mayan.R
\name{mayan_date}
\alias{mayan_date}
\alias{as_mayan}
\title{Mayan calendar dates}
\usage{
mayan_date(
  baktun = integer(),
  katun = integer(),
  tun = integer(),
  uinal = integer(),
  kin = integer()
)

as_mayan(date)
}
\arguments{
\item{baktun}{Numeric vector}

\item{katun}{Numeric vector}

\item{tun}{Numeric vector}

\item{uinal}{Numeric vector}

\item{kin}{Numeric vector}

\item{date}{Vector of dates on some calendar}
}
\value{
A mayan vector object
}
\description{
There are three Mayan calendars: the famous "long count" calendar, the "Haab" calendar, and the "Tzolkin" calendar.
Of these, only the long count calendar can be converted to and from other calendars, so it is the only one that
has been implemented here.
}
\details{
The Mayan long count calendar is a vigesimal (base-20) calendar with five components: kin (1 day), uinal (20 kin), tun (18 uinal), katun (20 tun), and baktun (20 katun). So the full cycle repeats every 20x18x20x20 = 144,000 days (approximately 394 years).
}
\examples{
gregorian_date(2012, 12, 10:30) |>
  as_mayan()
}
\seealso{
\link{cal_mayan}
}
