% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accordion.R
\name{calcite_accordion}
\alias{calcite_accordion}
\title{Create a Calcite Accordion Component}
\usage{
calcite_accordion(
  ...,
  id = NULL,
  appearance = NULL,
  icon_position = NULL,
  icon_type = NULL,
  scale = NULL,
  selection_mode = NULL
)
}
\arguments{
\item{...}{One or more \code{\link[=calcite_accordion_item]{calcite_accordion_item()}} components}

\item{id}{Component ID (required for Shiny reactivity)}

\item{appearance}{Visual style: "solid" or "transparent" (default: "solid")}

\item{icon_position}{Placement of the icon in the header: "start" or "end" (default: "end")}

\item{icon_type}{Type of icon in the header: "chevron", "caret", or "plus-minus" (default: "chevron")}

\item{scale}{Size of the component: "s" (small), "m" (medium), or "l" (large) (default: "m")}

\item{selection_mode}{Selection mode: "multiple" allows any number of selections, "single" allows only one selection, "single-persist" allows one selection and prevents de-selection (default: "multiple")}
}
\value{
An object of class \code{calcite_component}
}
\description{
Accordions are most often used for hiding and showing sections of related content.
They can have different selection modes, allowing users to have multiple or single
accordion item(s) open.
}
\details{
\subsection{Usage}{
\itemize{
\item To organize related text-based content.
\item To shorten pages and reduce scrolling when content is not crucial to read in full.
}
}

\subsection{Best practices}{
\itemize{
\item Use Accordion to contain related but distinct, primarily text-based content.
\item Use Accordion within the main content area of an application to save space.
\item Avoid using Accordion within a Panel. Instead, use one or more Block(s).
\item Avoid using Accordion to house interactive controls or form-based components.
}
}

\subsection{Shiny Integration}{

The accordion tracks which items are expanded based on its selection mode.

\strong{Available properties in \code{input$id}:}
\itemize{
\item \verb{$appearance} - The visual style
\item \verb{$iconPosition} - Icon placement
\item \verb{$iconType} - Icon type
\item \verb{$scale} - Size
\item \verb{$selectionMode} - Selection mode
}
}
}
\examples{
# Basic accordion with multiple selection
calcite_accordion(
  id = "my_accordion",
  calcite_accordion_item(
    heading = "Watercraft",
    description = "Yachts, boats, and dinghies",
    icon_start = "embark",
    "Recommended for coastal use"
  ),
  calcite_accordion_item(
    heading = "Automobiles",
    description = "Cars, trucks, and buses",
    icon_start = "car",
    "A good choice for inland adventure"
  )
)

# Single selection accordion
calcite_accordion(
  selection_mode = "single",
  appearance = "transparent",
  icon_type = "plus-minus",
  calcite_accordion_item(
    heading = "Section 1",
    "Content 1"
  ),
  calcite_accordion_item(
    heading = "Section 2",
    "Content 2"
  )
)
}
\references{
\href{https://developers.arcgis.com/calcite-design-system/components/accordion/}{Official Documentation}
}
