% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/action.R
\name{calcite_action}
\alias{calcite_action}
\title{Create a Calcite Action Component}
\usage{
calcite_action(
  text,
  icon = NULL,
  id = NULL,
  active = NULL,
  disabled = NULL,
  indicator = NULL,
  text_enabled = NULL,
  scale = NULL,
  alignment = NULL,
  appearance = NULL,
  loading = NULL,
  label = NULL,
  ...
)
}
\arguments{
\item{text}{Text label for the action (required, also used for accessibility)}

\item{icon}{Icon name from the Calcite icon set}

\item{id}{Optional ID for the action (required for Shiny reactivity)}

\item{active}{Whether the action is highlighted/selected}

\item{disabled}{Whether the action is disabled}

\item{indicator}{Whether to show a visual indicator (e.g., notification badge)}

\item{text_enabled}{Whether to display the text label alongside the icon}

\item{scale}{Size of the action: "s" (small), "m" (medium), or "l" (large)}

\item{alignment}{Text alignment: "start", "center", or "end"}

\item{appearance}{Visual style: "solid" or "transparent"}

\item{loading}{Whether to show a loading indicator}

\item{label}{Custom accessibility label (defaults to \code{text} if not provided)}

\item{...}{Additional attributes passed to the component}
}
\value{
An object of class \code{calcite_component}
}
\description{
Creates an action button that can be used within action bars and action groups.
Actions provide a compact way to trigger operations with icon-based buttons.
}
\details{
\subsection{Shiny Integration}{

When used in a Shiny app, \code{calcite_action()} returns a reactive list containing
all component properties. You can observe the entire component state or watch
individual properties:

\strong{Available properties:}
\itemize{
\item \verb{$clicked} - Boolean that toggles on each click (use this to detect clicks)
\item \verb{$active} - Whether the action is currently active/highlighted
\item \verb{$disabled} - Whether the action is disabled
\item \verb{$icon} - The icon name
\item \verb{$text} - The text label
\item \verb{$indicator} - Whether an indicator is shown
\item \verb{$alignment}, \verb{$appearance}, \verb{$scale}, etc. - Other component properties
}

\strong{Usage in server:}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# Watch for any change to the action (including clicks)
observeEvent(input$my_action, \{
  print("Action changed!")
\})

# Watch only the clicked state
observeEvent(input$my_action$clicked, \{
  print("Action was clicked!")
\})

# Access specific properties
observeEvent(input$my_action, \{
  is_active <- input$my_action$active
  click_state <- input$my_action$clicked
\})
}\if{html}{\out{</div>}}
}
}
\examples{
# Basic action with icon
calcite_action(
  text = "Layers",
  icon = "layers",
  id = "layers-action"
)

# Active action with text label
calcite_action(
  text = "Settings",
  icon = "gear",
  active = TRUE,
  text_enabled = TRUE
)

# Action with indicator
calcite_action(
  text = "Notifications",
  icon = "bell",
  indicator = TRUE
)

# Shiny example
if (interactive()) {
  library(shiny)

  ui <- calcite_shell(
    calcite_action(
      id = "my_action",
      text = "Click me",
      icon = "check",
      text_enabled = TRUE
    ),
    verbatimTextOutput("status")
  )

  server <- function(input, output, session) {
    # Respond to clicks
    observeEvent(input$my_action$clicked, {
      message("Action clicked! State: ", input$my_action$clicked)
    })

    # Display all properties
    output$status <- renderPrint({
      input$my_action
    })
  }

  shinyApp(ui, server)
}
}
\references{
\href{https://developers.arcgis.com/calcite-design-system/components/action/}{Official Documentation}
}
