% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/action-bar.R
\name{calcite_action_bar}
\alias{calcite_action_bar}
\title{Create a Calcite Action Bar Component}
\usage{
calcite_action_bar(
  ...,
  id = NULL,
  expand_disabled = NULL,
  expanded = NULL,
  floating = NULL,
  layout = NULL,
  overflow_actions_disabled = NULL,
  position = NULL,
  scale = NULL
)
}
\arguments{
\item{...}{\code{\link[=calcite_action]{calcite_action()}} or \code{\link[=calcite_action_group]{calcite_action_group()}} components}

\item{id}{Optional ID. When provided, \code{input$id} will contain the \code{text}
of the currently active action.}

\item{expand_disabled}{When \code{TRUE}, disables the expand/collapse toggle.}

\item{expanded}{When \code{TRUE}, the action bar is expanded showing text labels.}

\item{floating}{When \code{TRUE}, the component is in a floating state.}

\item{layout}{Layout direction of the actions: \code{"vertical"}, \code{"horizontal"},
or \code{"grid"}.}

\item{overflow_actions_disabled}{When \code{TRUE}, disables automatic overflowing
of actions into menus.}

\item{position}{Position of the component: \code{"start"} or \code{"end"}.}

\item{scale}{Size of the expand action: \code{"s"}, \code{"m"}, or \code{"l"}.}
}
\value{
An object of class \code{calcite_component}
}
\description{
Action Bar is composed of \code{\link[=calcite_action]{calcite_action()}}s used for core operations in
the interface. When given an \code{id}, it acts as a Shiny input that reports
the \code{text} of the currently active action as \code{input$id}.
}
\details{
\subsection{Shiny Integration}{

When \code{id} is provided, \code{input$id} returns the \code{text} of the currently
active \code{\link[=calcite_action]{calcite_action()}}. The action bar manages active state automatically
— clicking an action activates it and deactivates all others.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{observeEvent(input$my_bar, \{
  cat("Active action:", input$my_bar, "\\n")
\})
}\if{html}{\out{</div>}}

Use \code{update_calcite()} to programmatically set the active action by passing
the \code{text} value of the action to activate.
}
}
\examples{
calcite_action_bar(
  id = "my_bar",
  calcite_action(text = "Layers", icon = "layers", active = TRUE),
  calcite_action(text = "Legend", icon = "legend")
)
}
\references{
\href{https://developers.arcgis.com/calcite-design-system/components/action-bar/}{Official Documentation}
}
