% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/action-group.R
\name{calcite_action_group}
\alias{calcite_action_group}
\title{Create a Calcite Action Group Component}
\usage{
calcite_action_group(
  ...,
  id = NULL,
  layout = NULL,
  columns = NULL,
  scale = NULL,
  expanded = NULL,
  label = NULL,
  slot = NULL
)
}
\arguments{
\item{...}{Child \code{calcite_action()} components or other content}

\item{id}{Optional ID for the action group}

\item{layout}{Layout style: "vertical", "horizontal", or "grid"}

\item{columns}{Number of columns when layout is "grid" (1-6)}

\item{scale}{Size of the group: "s" (small), "m" (medium), or "l" (large)}

\item{expanded}{Whether the group is expanded}

\item{label}{Accessibility label for the group}

\item{slot}{Optional slot name (e.g., "bottom-actions" for action bars)}
}
\value{
An object of class \code{calcite_component}
}
\description{
Groups multiple action components together with consistent layout and spacing.
Action groups can be used within action bars to organize related actions.
}
\examples{
# Basic action group with vertical layout
calcite_action_group(
  calcite_action(text = "Add", icon = "plus"),
  calcite_action(text = "Edit", icon = "pencil"),
  calcite_action(text = "Delete", icon = "trash")
)

# Horizontal group with custom scale
calcite_action_group(
  layout = "horizontal",
  scale = "l",
  calcite_action(text = "Save", icon = "save"),
  calcite_action(text = "Cancel", icon = "x")
)

# Grid layout with 2 columns
calcite_action_group(
  layout = "grid",
  columns = 2,
  calcite_action(text = "A", icon = "letter-a"),
  calcite_action(text = "B", icon = "letter-b"),
  calcite_action(text = "C", icon = "letter-c"),
  calcite_action(text = "D", icon = "letter-d")
)
}
\references{
\href{https://developers.arcgis.com/calcite-design-system/components/action-group/}{Official Documentation}
}
