% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/block.R
\name{calcite_block}
\alias{calcite_block}
\title{Create a Calcite Block Component}
\usage{
calcite_block(
  ...,
  id = NULL,
  heading = NULL,
  description = NULL,
  collapsible = TRUE,
  expanded = TRUE,
  disabled = NULL,
  loading = NULL,
  icon_start = NULL,
  icon_end = NULL,
  icon_flip_rtl = NULL,
  scale = NULL,
  heading_level = NULL,
  label = NULL,
  drag_disabled = NULL,
  sort_handle_open = NULL,
  menu_placement = NULL,
  overlay_positioning = NULL
)
}
\arguments{
\item{...}{Child content for the block}

\item{id}{Component ID (required for Shiny reactivity)}

\item{heading}{Header text for the block}

\item{description}{Description text displayed below the heading}

\item{collapsible}{Whether the block can be collapsed (default: FALSE)}

\item{expanded}{Whether the block is currently expanded (default: FALSE)}

\item{disabled}{Whether interaction is prevented (default: FALSE)}

\item{loading}{Whether to display a busy indicator (default: FALSE)}

\item{icon_start}{Icon to display at the start of the header}

\item{icon_end}{Icon to display at the end of the header}

\item{icon_flip_rtl}{Flip icons in RTL languages: "start", "end", or "both"}

\item{scale}{Size of the component: "s" (small), "m" (medium), or "l" (large)}

\item{heading_level}{Semantic heading level (1-6) for accessibility}

\item{label}{Accessible name for the component}

\item{drag_disabled}{Prevent dragging when parent Block Group enables it (default: FALSE)}

\item{sort_handle_open}{Display and position the sort handle (default: FALSE)}

\item{menu_placement}{Placement of the action menu}

\item{overlay_positioning}{Positioning type for overlaid content: "absolute" or "fixed"}
}
\value{
An object of class \code{calcite_component}
}
\description{
Creates a collapsible block component designed to house content and controls
within a Panel, most often as part of an application layout with Shell Panels.
}
\details{
\subsection{Shiny Integration}{

The block emits events when it's expanded or collapsed, making it easy to track state.

\strong{Available properties in \code{input$id}:}
\itemize{
\item \verb{$expanded} - Whether the block is currently expanded
\item \verb{$collapsible} - Whether the block is collapsible
\item \verb{$disabled} - Whether the block is disabled
\item \verb{$heading} - The heading text
\item Other component properties
}

\strong{Basic usage:}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{calcite_block(
  id = "my_block",
  heading = "Layer effects",
  description = "Adjust blur, highlight, and more",
  collapsible = TRUE,
  expanded = TRUE,
  icon_start = "effects",
  # Block content...
)

# In server
observeEvent(input$my_block$expanded, \{
  if (input$my_block$expanded) \{
    message("Block was expanded")
  \} else \{
    message("Block was collapsed")
  \}
\})
}\if{html}{\out{</div>}}

\strong{Update from server:}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# Programmatically expand or collapse the block
update_calcite("my_block", expanded = TRUE)
update_calcite("my_block", expanded = FALSE)
}\if{html}{\out{</div>}}
}
}
\examples{
# Basic collapsible block
calcite_block(
  id = "effects_block",
  heading = "Layer effects",
  description = "Adjust blur, highlight, and more",
  collapsible = TRUE,
  icon_start = "effects",
  "Block content goes here..."
)
}
\references{
\href{https://developers.arcgis.com/calcite-design-system/components/block/}{Official Documentation}
}
