% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkbox.R
\name{calcite_checkbox}
\alias{calcite_checkbox}
\title{Create a Calcite Checkbox Component}
\usage{
calcite_checkbox(
  id = NULL,
  checked = NULL,
  disabled = NULL,
  form = NULL,
  indeterminate = NULL,
  label = NULL,
  label_text = NULL,
  name = NULL,
  required = NULL,
  scale = NULL,
  status = NULL,
  value = NULL
)
}
\arguments{
\item{id}{Component ID (required for Shiny reactivity)}

\item{checked}{When \code{TRUE}, the component is checked. Default: \code{FALSE}}

\item{disabled}{When \code{TRUE}, interaction is prevented and the component is
displayed with lower opacity. Default: \code{FALSE}}

\item{form}{Specifies the id of the component's associated form.}

\item{indeterminate}{When \code{TRUE}, the component is initially indeterminate,
independent from its checked value. Visual only. Default: \code{FALSE}}

\item{label}{Specifies an accessible label for the component.}

\item{label_text}{Specifies the component's label text.}

\item{name}{Specifies the name of the component. Required to pass the
component's value on form submission.}

\item{required}{When \code{TRUE} and the component resides in a form, the
component must have a value in order for the form to submit. Default: \code{FALSE}}

\item{scale}{Specifies the size of the component: \code{"s"}, \code{"m"}, or \code{"l"}.
Default: \code{"m"}}

\item{status}{Specifies the status of the input field: \code{"idle"}, \code{"invalid"},
or \code{"valid"}. Default: \code{"idle"}}

\item{value}{The component's value.}
}
\value{
An object of class \code{calcite_component}
}
\description{
A checkbox allows users to make a binary selection, typically within a form
or as a standalone toggle. Supports indeterminate state for tri-state behavior.
}
\details{
\subsection{Shiny Integration}{

When an \code{id} is provided, the checkbox emits its state whenever it changes.

\strong{Available properties in \code{input$id}:}
\itemize{
\item \verb{$checked} - Whether the checkbox is checked
\item \verb{$indeterminate} - Whether the checkbox is in indeterminate state
\item \verb{$value} - The component's value
\item \verb{$disabled} - Whether the checkbox is disabled
\item \verb{$name} - The component's name
\item \verb{$scale} - The component's scale
\item \verb{$status} - The component's status
}

\strong{Events:}
\itemize{
\item \code{calciteCheckboxChange} - Fires when the checked status changes
}
}
}
\examples{
calcite_checkbox(id = "agree", label_text = "I agree to the terms")

calcite_checkbox(
  id = "opt_in",
  label_text = "Subscribe to newsletter",
  checked = TRUE,
  scale = "l"
)
}
\references{
\href{https://developers.arcgis.com/calcite-design-system/components/checkbox/}{Official Documentation}
}
