% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input-message.R
\name{calcite_input_message}
\alias{calcite_input_message}
\title{Create a Calcite Input Message Component}
\usage{
calcite_input_message(
  ...,
  status = NULL,
  icon = NULL,
  icon_flip_rtl = NULL,
  scale = NULL,
  id = NULL
)
}
\arguments{
\item{...}{Content for the message (default slot) - typically text or textOutput()}

\item{status}{Status of the message: "idle", "valid", or "invalid" (default: "idle")}

\item{icon}{Specifies an icon to display (TRUE for default or icon name)}

\item{icon_flip_rtl}{When TRUE, icon is flipped in RTL direction (default: FALSE)}

\item{scale}{Size of the component: "s", "m", or "l" (default: "m")}

\item{id}{Component ID (optional)}
}
\value{
An object of class \code{calcite_component}
}
\description{
Creates a message component that displays validation messages, hints, and other
contextual feedback for input components.
}
\details{
\subsection{Usage}{

Input messages are typically used inside a \code{calcite_label()} component alongside
an input to provide contextual feedback, validation messages, or hints.
}

\subsection{Status Options}{
\itemize{
\item \strong{"valid"}: Green checkmark icon, success message
\item \strong{"invalid"}: Red warning icon, error message
\item \strong{"idle"}: Default state, informational message
}
}

\subsection{Dynamic Messages}{

Use \code{textOutput()} in the slot and \code{renderText()} in the server to create dynamic
validation messages. Use \code{update_calcite()} to change the status/icon properties.
}
}
\examples{
# Static message
calcite_input_message(
  "Username is available",
  status = "valid",
  icon = TRUE
)

# Dynamic message with textOutput
calcite_input_message(
  shiny::textOutput("validation_msg"),
  status = "invalid",
  icon = "exclamation-mark-circle",
  id = "msg"
)

# With input in a label
calcite_label(
  label = "Username",
  calcite_input_text(
    id = "username",
    placeholder = "Enter username"
  ),
  calcite_input_message(
    "Username must be 3-20 characters",
    status = "idle"
  )
)
}
\references{
\href{https://developers.arcgis.com/calcite-design-system/components/input-message/}{Official Documentation}
}
