% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input-number.R
\name{calcite_input_number}
\alias{calcite_input_number}
\title{Create a Calcite Input Number Component}
\usage{
calcite_input_number(
  id = NULL,
  value = NULL,
  name = NULL,
  placeholder = NULL,
  label = NULL,
  label_text = NULL,
  alignment = NULL,
  autocomplete = NULL,
  clearable = NULL,
  disabled = NULL,
  form = NULL,
  group_separator = NULL,
  icon = NULL,
  icon_flip_rtl = NULL,
  integer = NULL,
  loading = NULL,
  max = NULL,
  min = NULL,
  number_button_type = NULL,
  numbering_system = NULL,
  prefix_text = NULL,
  read_only = NULL,
  required = NULL,
  scale = NULL,
  status = NULL,
  step = NULL,
  suffix_text = NULL,
  validation_icon = NULL,
  validation_message = NULL,
  action = NULL,
  label_content = NULL
)
}
\arguments{
\item{id}{Component ID (required for Shiny reactivity)}

\item{value}{The component's value}

\item{name}{Specifies the name of the component (required for form submission)}

\item{placeholder}{Specifies placeholder text for the component}

\item{label}{Accessible name for the component}

\item{label_text}{When provided, displays label text on the component}

\item{alignment}{Text alignment of the value: "start", "center", or "end" (default: "start")}

\item{autocomplete}{Type of content to autocomplete for forms}

\item{clearable}{When TRUE, shows a clear button when the component has a value (default: FALSE)}

\item{disabled}{When TRUE, interaction is prevented and displayed with lower opacity (default: FALSE)}

\item{form}{The id of the form associated with the component}

\item{group_separator}{When TRUE, number values display with a group separator
corresponding to the language and country format (default: FALSE)}

\item{icon}{Specifies an icon to display (TRUE for default or icon name)}

\item{icon_flip_rtl}{When TRUE, icon is flipped in RTL direction (default: FALSE)}

\item{integer}{When TRUE, restricts the component to integer numbers only and
disables exponential notation (default: FALSE)}

\item{loading}{When TRUE, displays a busy indicator (default: FALSE)}

\item{max}{Maximum value for the input}

\item{min}{Minimum value for the input}

\item{number_button_type}{Placement of the increment/decrement buttons: "vertical",
"horizontal", or "none" (default: "vertical")}

\item{numbering_system}{Unicode numeral system: "arab", "arabext", or "latn"}

\item{prefix_text}{Text to display at the start of the component}

\item{read_only}{When TRUE, value can be read but not modified (default: FALSE)}

\item{required}{When TRUE, must have a value for form submission (default: FALSE)}

\item{scale}{Size of the component: "s", "m", or "l" (default: "m")}

\item{status}{Status of the input field: "idle", "valid", or "invalid" (default: "idle")}

\item{step}{Granularity the value must adhere to (can be "any" or a number)}

\item{suffix_text}{Text to display at the end of the component}

\item{validation_icon}{Validation icon to display (TRUE or icon name)}

\item{validation_message}{Validation message to display}

\item{action}{Content for the action slot (typically a calcite_action)}

\item{label_content}{Content for the label-content slot}
}
\value{
An object of class \code{calcite_component}
}
\description{
Creates a number input component for form entry where users can enter numeric values.
Supports integer-only mode, min/max constraints, and number formatting.
}
\details{
\subsection{Shiny Integration}{

When used in a Shiny app, \code{calcite_input_number()} returns a reactive list containing:

\strong{Available properties:}
\itemize{
\item \verb{$value} - The current numeric value (as string)
\item \verb{$validity} - Object containing validation state (valid, badInput, rangeOverflow, etc.)
\item \verb{$status} - Current status ("idle", "valid", "invalid")
\item Other component properties
}

\strong{Usage in server:}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# Watch for value changes
observeEvent(input$age$value, \{
  age_num <- as.numeric(input$age$value)
  print(paste("Age:", age_num))
\})

# Check validity
observeEvent(input$age, \{
  if (input$age$validity$valid) \{
    print("Valid number entered")
  \}
  if (input$age$validity$rangeOverflow) \{
    print("Number is too large")
  \}
\})
}\if{html}{\out{</div>}}
}
}
\examples{
# Basic number input
calcite_input_number(
  id = "quantity",
  placeholder = "Enter quantity"
)

# Integer-only input with constraints
calcite_input_number(
  id = "age",
  integer = TRUE,
  min = 0,
  max = 120,
  step = 1,
  required = TRUE
)

# Price input with formatting
calcite_input_number(
  id = "price",
  prefix_text = "$",
  group_separator = TRUE,
  step = 0.01,
  min = 0
)

# Percentage input
calcite_input_number(
  id = "percent",
  suffix_text = "\%",
  min = 0,
  max = 100,
  step = 1
)
}
\references{
\href{https://developers.arcgis.com/calcite-design-system/components/input-number/}{Official Documentation}
}
