% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input-text.R
\name{calcite_input_text}
\alias{calcite_input_text}
\title{Create a Calcite Input Text Component}
\usage{
calcite_input_text(
  id = NULL,
  value = NULL,
  name = NULL,
  placeholder = NULL,
  label = NULL,
  label_text = NULL,
  alignment = NULL,
  autocomplete = NULL,
  clearable = NULL,
  disabled = NULL,
  form = NULL,
  icon = NULL,
  icon_flip_rtl = NULL,
  loading = NULL,
  max_length = NULL,
  min_length = NULL,
  pattern = NULL,
  prefix_text = NULL,
  read_only = NULL,
  required = NULL,
  scale = NULL,
  status = NULL,
  suffix_text = NULL,
  validation_icon = NULL,
  validation_message = NULL,
  action = NULL,
  label_content = NULL
)
}
\arguments{
\item{id}{Component ID (required for Shiny reactivity)}

\item{value}{The component's value}

\item{name}{Specifies the name of the component (required for form submission)}

\item{placeholder}{Specifies placeholder text for the component}

\item{label}{Accessible name for the component}

\item{label_text}{When provided, displays label text on the component}

\item{alignment}{Text alignment of the value: "start", "center", or "end" (default: "start")}

\item{autocomplete}{Type of content to autocomplete for forms}

\item{clearable}{When TRUE, shows a clear button when the component has a value (default: FALSE)}

\item{disabled}{When TRUE, interaction is prevented and displayed with lower opacity (default: FALSE)}

\item{form}{The id of the form associated with the component}

\item{icon}{Specifies an icon to display (TRUE for default or icon name)}

\item{icon_flip_rtl}{When TRUE, icon is flipped in RTL direction (default: FALSE)}

\item{loading}{When TRUE, displays a busy indicator (default: FALSE)}

\item{max_length}{Maximum length of text for the component's value}

\item{min_length}{Minimum length of text for the component's value}

\item{pattern}{Regular expression pattern the value must match for validation}

\item{prefix_text}{Text to display at the start of the component}

\item{read_only}{When TRUE, value can be read but not modified (default: FALSE)}

\item{required}{When TRUE, must have a value for form submission (default: FALSE)}

\item{scale}{Size of the component: "s", "m", or "l" (default: "m")}

\item{status}{Status of the input field: "idle", "valid", or "invalid" (default: "idle")}

\item{suffix_text}{Text to display at the end of the component}

\item{validation_icon}{Validation icon to display (TRUE or icon name)}

\item{validation_message}{Validation message to display}

\item{action}{Content for the action slot (typically a calcite_action)}

\item{label_content}{Content for the label-content slot}
}
\value{
An object of class \code{calcite_component}
}
\description{
Creates a text input component for form entry where users can enter text values.
Supports validation, length constraints, and pattern matching.
}
\details{
\subsection{Shiny Integration}{

When used in a Shiny app, \code{calcite_input_text()} returns a reactive list containing:

\strong{Available properties:}
\itemize{
\item \verb{$value} - The current text value
\item \verb{$validity} - Object containing validation state (valid, tooLong, tooShort, patternMismatch, etc.)
\item \verb{$status} - Current status ("idle", "valid", "invalid")
\item Other component properties
}

\strong{Usage in server:}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# Watch for value changes
observeEvent(input$username$value, \{
  print(paste("Username:", input$username$value))
\})

# Check validity
observeEvent(input$username, \{
  if (input$username$validity$valid) \{
    print("Valid username entered")
  \}
  if (input$username$validity$tooShort) \{
    print("Username is too short")
  \}
\})
}\if{html}{\out{</div>}}
}
}
\examples{
# Basic text input
calcite_input_text(
  id = "username",
  placeholder = "Enter username"
)

# Text input with length constraints
calcite_input_text(
  id = "username",
  min_length = 3,
  max_length = 20,
  required = TRUE
)

# Text input with pattern validation
calcite_input_text(
  id = "zip_code",
  pattern = "\\\\d{5}",
  placeholder = "12345"
)

# Search input with icon
calcite_input_text(
  id = "search",
  icon = "search",
  clearable = TRUE,
  placeholder = "Search..."
)
}
\references{
\href{https://developers.arcgis.com/calcite-design-system/components/input-text/}{Official Documentation}
}
