% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/link.R
\name{calcite_link}
\alias{calcite_link}
\title{Create a Calcite Link Component}
\usage{
calcite_link(
  text,
  href,
  id = NULL,
  disabled = NULL,
  download = NULL,
  icon_end = NULL,
  icon_flip_rtl = NULL,
  icon_start = NULL,
  rel = NULL,
  target = NULL
)
}
\arguments{
\item{text}{The link text to display (required)}

\item{href}{The URL of the linked resource (required) - can be absolute or relative path}

\item{id}{Component ID (optional)}

\item{disabled}{When TRUE, interaction is prevented and the component is displayed
with lower opacity (default: FALSE)}

\item{download}{Prompts the user to save the linked URL instead of navigating to it.
Can be TRUE or a string filename}

\item{icon_end}{Specifies an icon to display at the end of the link}

\item{icon_flip_rtl}{Displays the iconStart and/or iconEnd as flipped when the
element direction is RTL: "both", "end", or "start"}

\item{icon_start}{Specifies an icon to display at the start of the link}

\item{rel}{Specifies the relationship to the linked document (e.g., "noopener", "noreferrer")}

\item{target}{Specifies the frame or window to open the linked document
(e.g., "_blank", "_self", "_parent", "_top")}
}
\value{
An object of class \code{calcite_component}
}
\description{
Creates a link component for navigation or performing actions. Links are useful
for tertiary-level actions or inline navigation within text.
}
\details{
\subsection{Usage Guidelines}{

\strong{Use Links for:}
\itemize{
\item Navigation to another page or section
\item Tertiary-level actions in a group
\item Inline actions within sentences
}

\strong{Use Buttons instead for:}
\itemize{
\item Primary actions like "Create", "Submit", "Upload"
\item Task completion actions
\item Prominent calls to action
}
}

\subsection{Best Practices}{
\itemize{
\item Avoid making entire sentences into links
\item Link text should be descriptive of the destination
\item Use \code{target = "_blank"} with \code{rel = "noopener noreferrer"} for external links
}
}
}
\examples{
# Basic link
calcite_link(
  text = "View documentation",
  href = "https://developers.arcgis.com/calcite-design-system/"
)

# Link with icon
calcite_link(
  text = "External site",
  href = "https://example.com",
  icon_end = "launch",
  target = "_blank",
  rel = "noopener noreferrer"
)

# Download link
calcite_link(
  text = "Download report",
  href = "/files/report.pdf",
  download = "monthly-report.pdf",
  icon_start = "download"
)

# Disabled link
calcite_link(
  text = "Coming soon",
  href = "#",
  disabled = TRUE
)
}
\references{
\href{https://developers.arcgis.com/calcite-design-system/components/link/}{Official Documentation}
}
