% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segmented-control.R
\name{calcite_segmented_control}
\alias{calcite_segmented_control}
\title{Create a Calcite Segmented Control Component}
\usage{
calcite_segmented_control(
  ...,
  id = NULL,
  value = NULL,
  appearance = NULL,
  disabled = NULL,
  layout = NULL,
  scale = NULL,
  width = NULL,
  name = NULL,
  label_text = NULL,
  status = NULL,
  validation_message = NULL,
  required = NULL
)
}
\arguments{
\item{...}{Additional attributes passed to the component}

\item{id}{Component ID (required for Shiny reactivity)}

\item{value}{Initial selected value (should match a child item's value)}

\item{appearance}{Visual style: "solid", "outline", or "outline-fill"}

\item{disabled}{Whether the control is disabled (default: FALSE)}

\item{layout}{Orientation: "horizontal" or "vertical"}

\item{scale}{Size of the control: "s" (small), "m" (medium), or "l" (large)}

\item{width}{Width behavior: "auto" or "full"}

\item{name}{Name for form submission}

\item{label_text}{Label displayed on the component}

\item{status}{Validation state: "idle", "valid", or "invalid"}

\item{validation_message}{Message displayed for validation feedback}

\item{required}{Whether selection is required}
}
\value{
An object of class \code{calcite_component}
}
\description{
Creates a segmented control for selecting between multiple options. Similar to
radio buttons but with a more compact, segmented button appearance.
}
\details{
\subsection{Shiny Integration}{

The segmented control emits a \code{calciteSegmentedControlChange} event when the
selected item changes.

\strong{Available properties in \code{input$id}:}
\itemize{
\item \verb{$value} - Currently selected value (matches a child item's value attribute)
\item \verb{$disabled} - Whether the control is disabled
\item \verb{$scale} - Current scale setting
\item Other component properties
}

\strong{Basic usage:}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{calcite_segmented_control(
  id = "effect_type",
  width = "full",
  calcite_segmented_control_item(value = "blur"),
  calcite_segmented_control_item(value = "highlight", checked = TRUE),
  calcite_segmented_control_item(value = "party")
)

# In server
observeEvent(input$effect_type, \{
  selected <- input$effect_type$value
  print(paste("Selected:", selected))
\})
}\if{html}{\out{</div>}}

\strong{Update from server:}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{update_calcite("effect_type", value = "blur")
}\if{html}{\out{</div>}}
}
}
\examples{
# Basic segmented control
calcite_segmented_control(
  id = "view_mode",
  calcite_segmented_control_item(value = "list", icon_start = "list"),
  calcite_segmented_control_item(value = "grid", icon_start = "grid", checked = TRUE),
  calcite_segmented_control_item(value = "table", icon_start = "table")
)

# Full width with text
calcite_segmented_control(
  id = "effect",
  width = "full",
  calcite_segmented_control_item(value = "Blur"),
  calcite_segmented_control_item(value = "Highlight", checked = TRUE),
  calcite_segmented_control_item(value = "Party mode")
)

# Shiny example
if (interactive()) {
  library(shiny)

  ui <- calcite_shell(
    calcite_card(
      heading = "Segmented Control Example",
      calcite_label(
        "Choose an option",
        calcite_segmented_control(
          id = "my_control",
          width = "full",
          calcite_segmented_control_item(value = "option1"),
          calcite_segmented_control_item(value = "option2", checked = TRUE),
          calcite_segmented_control_item(value = "option3")
        )
      ),
      verbatimTextOutput("selected_value")
    )
  )

  server <- function(input, output, session) {
    output$selected_value <- renderPrint({
      paste("Selected:", input$my_control$value)
    })
  }

  shinyApp(ui, server)
}
}
\references{
\href{https://developers.arcgis.com/calcite-design-system/components/segmented-control/}{Official Documentation}
}
