% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segmented-control.R
\name{calcite_segmented_control_item}
\alias{calcite_segmented_control_item}
\title{Create a Calcite Segmented Control Item Component}
\usage{
calcite_segmented_control_item(
  value,
  label = value,
  checked = NULL,
  icon_start = NULL,
  icon_end = NULL,
  icon_flip_rtl = NULL,
  ...
)
}
\arguments{
\item{value}{The value this item represents (required)}

\item{label}{Text label displayed for the item (defaults to \code{value})}

\item{checked}{Whether this item is initially selected (default: FALSE)}

\item{icon_start}{Icon to display at the start of the item}

\item{icon_end}{Icon to display at the end of the item}

\item{icon_flip_rtl}{Whether to flip the icon in RTL languages (default: FALSE)}

\item{...}{Additional content or attributes (text label if provided as unnamed argument)}
}
\value{
An object of class \code{calcite_component}
}
\description{
Creates an individual item within a segmented control. Must be used as a child
of \code{calcite_segmented_control()}.
}
\examples{
# Item with text label
calcite_segmented_control_item(value = "option1")

# Item with icon
calcite_segmented_control_item(
  value = "list",
  icon_start = "list"
)

# Initially selected item
calcite_segmented_control_item(
  value = "default",
  checked = TRUE
)
}
\references{
\href{https://developers.arcgis.com/calcite-design-system/components/segmented-control-item/}{Official Documentation}
}
