% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select.R
\name{calcite_select}
\alias{calcite_select}
\title{Create a Calcite Select Component}
\usage{
calcite_select(
  ...,
  values = NULL,
  labels = NULL,
  id = NULL,
  label,
  disabled = NULL,
  form = NULL,
  label_text = NULL,
  message_overrides = NULL,
  name = NULL,
  required = NULL,
  scale = NULL,
  status = NULL,
  validation_icon = NULL,
  validation_message = NULL,
  value = NULL,
  width = NULL,
  label_content = NULL
)
}
\arguments{
\item{...}{calcite-option components (default slot). Ignored if \code{values} is provided.}

\item{values}{Character vector of option values. When provided, options are automatically
generated from \code{values} and \code{labels}. Takes precedence over manually constructed options in \code{...}.}

\item{labels}{Character vector of option labels (display text). Must be same length as \code{values}.
If NULL, uses \code{values} as labels.}

\item{id}{Component ID (required for Shiny reactivity)}

\item{label}{Accessible name for the component (required)}

\item{disabled}{When true, interaction is prevented and the component is displayed with lower opacity}

\item{form}{The id of the form that will be associated with the component}

\item{label_text}{When provided, displays label text on the component}

\item{message_overrides}{Override individual strings used by the component}

\item{name}{Specifies the name of the component. Required to pass the component's value on form submission}

\item{required}{When true, the component must have a value for the form to submit}

\item{scale}{Specifies the size of the component: "s" (small), "m" (medium), or "l" (large)}

\item{status}{Specifies the status of the input field: "idle", "invalid", or "valid"}

\item{validation_icon}{Specifies the validation icon to display under the component}

\item{validation_message}{Specifies the validation message to display under the component}

\item{value}{The component's selectedOption value}

\item{width}{Specifies the width of the component: "auto", "full", or "half" (half is deprecated)}

\item{label_content}{Content to render next to the component's labelText (slot)}
}
\value{
An object of class \code{calcite_component}
}
\description{
Select provides a single-selection dropdown menu for forms. It displays
a list of options that users can choose from. You can either provide
\code{values} and \code{labels} vectors for convenience, or manually construct
\code{\link[=calcite_option]{calcite_option()}} components.
}
\details{
\subsection{Shiny Integration}{

When used in a Shiny app, \code{calcite_select()} returns a reactive list containing
the component's state. The component emits a \code{calciteSelectChange} event when
the selection changes.

\strong{Available properties in \code{input$id}:}
\itemize{
\item \verb{$value} - The value of the selected option
\item \verb{$disabled} - Whether the select is disabled
\item \verb{$scale} - The size of the component
\item \verb{$status} - The validation status
\item Other component properties
}

\strong{Events:}
\itemize{
\item \code{calciteSelectChange} - Fires when the selected option changes
}
}
}
\examples{
# Using values and labels vectors (convenient)
calcite_select(
  id = "my_select",
  label = "Choose terrain type",
  values = c("mountains", "rivers", "lakes", "buttes", "fjords"),
  labels = c("Mountains", "Rivers", "Lakes", "Buttes", "Fjords")
)

# Using values only (labels default to values)
calcite_select(
  id = "simple_select",
  label = "Choose an option",
  values = c("option1", "option2", "option3")
)

# Manually constructing options (more control)
calcite_select(
  id = "fruit_select",
  label = "Choose a fruit",
  label_text = "Select your favorite fruit",
  scale = "m",
  calcite_option(label = "Apple", value = "apple"),
  calcite_option(label = "Banana", value = "banana", selected = TRUE),
  calcite_option(label = "Orange", value = "orange")
)

# Required select with validation
calcite_select(
  id = "required_select",
  label = "Required field",
  label_text = "Make a selection",
  required = TRUE,
  status = "invalid",
  validation_message = "Please select an option",
  calcite_option(label = "Choose...", value = ""),
  calcite_option(label = "Option A", value = "a"),
  calcite_option(label = "Option B", value = "b")
)
}
\references{
\href{https://developers.arcgis.com/calcite-design-system/components/select/}{Official Documentation}
}
